/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.client;

import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.client.KeybindHandler;
import mrbysco.constructionstick.client.RenderBlockPreview;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.items.template.ItemAngelTemplate;
import mrbysco.constructionstick.items.template.ItemDestructionTemplate;
import mrbysco.constructionstick.registry.ModDataComponents;
import mrbysco.constructionstick.registry.ModItems;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredItem;

public class ClientHandler {
    public static RenderBlockPreview renderBlockPreview;

    public static void onClientSetup(FMLClientSetupEvent event) {
        renderBlockPreview = new RenderBlockPreview();
        NeoForge.EVENT_BUS.register((Object)renderBlockPreview);
        NeoForge.EVENT_BUS.register((Object)new KeybindHandler());
        event.enqueueWork(ClientHandler::registerModelProperties);
    }

    public static void registerKeymapping(RegisterKeyMappingsEvent event) {
        event.register(KeybindHandler.KEY_CHANGE_RESTRICTION);
        event.register(KeybindHandler.KEY_CHANGE_UPGRADE);
        event.register(KeybindHandler.KEY_CHANGE_DIRECTION);
        event.register(KeybindHandler.KEY_OPEN_GUI);
        event.register(KeybindHandler.KEY_UNDO);
        event.register(KeybindHandler.KEY_SHOW_PREVIOUS);
    }

    public static void registerModelProperties() {
        for (DeferredItem<ItemStick> itemSupplier : ModItems.STICKS) {
            Item item = (Item)itemSupplier.get();
            ItemProperties.register((Item)item, (ResourceLocation)ConstructionStick.modLoc("angel_selected"), (stack, world, entity, n) -> stack.getItem() instanceof ItemStick && stack.has(ModDataComponents.SELECTED) && ((ResourceLocation)stack.get(ModDataComponents.SELECTED)).equals((Object)ItemAngelTemplate.UPGRADE_ID) ? 1.0f : 0.0f);
            ItemProperties.register((Item)item, (ResourceLocation)ConstructionStick.modLoc("destruction_selected"), (stack, world, entity, n) -> stack.getItem() instanceof ItemStick && stack.has(ModDataComponents.SELECTED) && ((ResourceLocation)stack.get(ModDataComponents.SELECTED)).equals((Object)ItemDestructionTemplate.UPGRADE_ID) ? 1.0f : 0.0f);
        }
    }
}

