/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.guielement.DumpGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class DumpGuiElementWidget
extends TexturedGuiElementWidget<DumpGuiElement> {
    private static final Component TITLE = Component.translatable((String)"custommachinery.gui.element.dump.name");
    private final List<Component> tooltips;

    public DumpGuiElementWidget(DumpGuiElement element, IMachineScreen screen) {
        super(element, screen, TITLE);
        this.tooltips = Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"custommachinery.gui.element.dump.name"), Component.translatable((String)"custommachinery.gui.element.dump.tooltip", (Object[])new Object[]{this.formatComponents(element.getComponents())}).withStyle(ChatFormatting.DARK_RED)});
    }

    private String formatComponents(List<MachineComponentType<?>> types) {
        StringBuilder builder = new StringBuilder();
        Iterator<MachineComponentType<?>> iterator = types.iterator();
        while (iterator.hasNext()) {
            MachineComponentType<?> type = iterator.next();
            builder.append(Objects.requireNonNull(Registration.MACHINE_COMPONENT_TYPE_REGISTRY.getKey(type)).getPath());
            if (!iterator.hasNext()) continue;
            builder.append(Component.literal((String)", "));
        }
        return builder.toString();
    }

    @Override
    public List<Component> getTooltips() {
        if (((DumpGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return this.tooltips;
        }
        return ((DumpGuiElement)this.getElement()).getTooltips();
    }
}

