/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.model;

import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.client.model.CustomMachineOverrideList;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineModelLocation;
import fr.frinn.custommachinery.impl.util.IMachineModelLocation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class CustomMachineBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<MachineAppearance> APPEARANCE = new ModelProperty();
    public static final ModelProperty<MachineStatus> STATUS = new ModelProperty();
    private final CustomMachineOverrideList overrideList = new CustomMachineOverrideList();
    private final Map<MachineStatus, ResourceLocation> defaults;

    public CustomMachineBakedModel(Map<MachineStatus, ResourceLocation> defaults) {
        this.defaults = defaults;
    }

    public boolean useAmbientOcclusion() {
        return (Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        try {
            return this.getMachineModel(data).getRenderTypes(state, rand, data);
        }
        catch (IllegalArgumentException ignored) {
            return ChunkRenderTypeSet.all();
        }
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        return CustomMachineItem.getMachine(stack).map(machine -> this.getMachineItemModel(machine.getAppearance(MachineStatus.IDLE)).getRenderTypes(stack, fabulous)).orElse(List.of(RenderTypeHelper.getFallbackItemRenderType((ItemStack)stack, (BakedModel)this, (boolean)fabulous)));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType type) {
        BakedModel model = this.getMachineModel(data);
        if (state != null && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return this.getRotatedQuads(model, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), side, rand, type);
        }
        return model.getQuads(state, side, rand, ModelData.EMPTY, type);
    }

    private List<BakedQuad> getRotatedQuads(BakedModel model, Direction machineFacing, Direction side, RandomSource random, RenderType type) {
        Direction originalSide = this.getRotatedDirection(machineFacing, side);
        List finalQuads = model.getQuads(null, originalSide, random, ModelData.EMPTY, type);
        return finalQuads.stream().map(quad -> this.rotateQuad((BakedQuad)quad, this.getRotation(machineFacing), side == null ? quad.getDirection() : side)).toList();
    }

    private Quaternionf getRotation(Direction machineFacing) {
        return switch (machineFacing) {
            case Direction.EAST -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 90.0f);
            case Direction.SOUTH -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 180.0f);
            case Direction.WEST -> new Quaternionf().fromAxisAngleDeg(0.0f, -1.0f, 0.0f, 270.0f);
            default -> new Quaternionf();
        };
    }

    private BakedQuad rotateQuad(BakedQuad quad, Quaternionf rotation, Direction side) {
        int[] quadData = quad.getVertices();
        int[] newQuadData = Arrays.copyOf(quadData, quadData.length);
        for (int i = 0; i < quadData.length / 8; ++i) {
            float x = Float.intBitsToFloat(quadData[i * 8]);
            float y = Float.intBitsToFloat(quadData[i * 8 + 1]);
            float z = Float.intBitsToFloat(quadData[i * 8 + 2]);
            Vector4f pos = new Vector4f(x - 0.5f, y - 0.5f, z - 0.5f, 1.0f);
            pos.rotate((Quaternionfc)rotation);
            pos.div(pos.w);
            newQuadData[i * 8] = Float.floatToRawIntBits(pos.x() + 0.5f);
            newQuadData[i * 8 + 1] = Float.floatToRawIntBits(pos.y() + 0.5f);
            newQuadData[i * 8 + 2] = Float.floatToRawIntBits(pos.z() + 0.5f);
            newQuadData[i * 8 + 7] = 0;
        }
        return new BakedQuad(newQuadData, quad.getTintIndex(), side, quad.getSprite(), quad.isShade());
    }

    public Direction getRotatedDirection(Direction machineFacing, @Nullable Direction quad) {
        if (quad == null || quad.getAxis() == Direction.Axis.Y) {
            return quad;
        }
        return switch (machineFacing) {
            case Direction.WEST -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 1) % 4));
            case Direction.SOUTH -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 2) % 4));
            case Direction.EAST -> Direction.from2DDataValue((int)((quad.get2DDataValue() + 3) % 4));
            default -> quad;
        };
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getMachineModel(data).getParticleIcon(data);
    }

    private BakedModel getMachineModel(@NotNull ModelData data) {
        MachineAppearance appearance = (MachineAppearance)data.get(APPEARANCE);
        MachineStatus status = (MachineStatus)((Object)data.get(STATUS));
        BakedModel model = appearance != null ? this.getMachineBlockModel(appearance, (MachineStatus)((Object)data.get(STATUS))) : (data.get(STATUS) != null ? Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)this.defaults.get((Object)status))) : Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)this.defaults.get((Object)MachineStatus.IDLE))));
        return model;
    }

    public BakedModel getMachineBlockModel(IMachineAppearance appearance, @Nullable MachineStatus status) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.getInstance().getModelManager().getMissingModel();
        IMachineModelLocation blockModelLocation = appearance.getBlockModel();
        if (blockModelLocation.getState() != null) {
            model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockModelLocation.getState());
        } else if (blockModelLocation.getLoc() != null && blockModelLocation.getProperties() != null) {
            model = Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(blockModelLocation.getLoc(), blockModelLocation.getProperties()));
        } else if (blockModelLocation.getLoc() != null) {
            model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)blockModelLocation.getLoc()));
        }
        if (model == missing) {
            model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)this.defaults.get((Object)(status == null ? MachineStatus.IDLE : status))));
        }
        return model;
    }

    public BakedModel getMachineItemModel(@Nullable IMachineAppearance appearance) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.getInstance().getModelManager().getMissingModel();
        if (appearance != null) {
            IMachineModelLocation itemModelLocation = appearance.getItemModel();
            if (itemModelLocation.getItem() != null && itemModelLocation.getItem() != Items.AIR) {
                model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(itemModelLocation.getItem());
            } else if (itemModelLocation.getLoc() != null && !itemModelLocation.getLoc().equals((Object)MachineModelLocation.DEFAULT.getLoc())) {
                Item item = (Item)BuiltInRegistries.ITEM.get(itemModelLocation.getLoc());
                model = itemModelLocation.getProperties() != null ? Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(itemModelLocation.getLoc(), itemModelLocation.getProperties())) : (item != Items.AIR && Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item) != null ? Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item) : Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)itemModelLocation.getLoc())));
            }
            if (model == missing) {
                model = this.getMachineBlockModel(appearance, MachineStatus.IDLE);
            }
        }
        if (model == missing) {
            model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)this.defaults.get((Object)MachineStatus.IDLE)));
        }
        return model;
    }
}

