/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.frinn.custommachinery.client.RenderTypes;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.init.StructureCreatorItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StructureCreatorRenderer {
    public static void renderSelectedBlocks(PoseStack pose) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.getMainHandItem().getItem() == Registration.STRUCTURE_CREATOR_ITEM.get()) {
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer builder = buffer.getBuffer(RenderTypes.THICK_LINES);
            Vec3 playerPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            List<BlockPos> blocks = StructureCreatorItem.getSelectedBlocks(Minecraft.getInstance().player.getMainHandItem());
            blocks.forEach(pos -> {
                AABB box = new AABB(pos);
                pose.pushPose();
                pose.translate(-playerPos.x(), -playerPos.y(), -playerPos.z());
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                pose.popPose();
            });
            buffer.endBatch(RenderTypes.THICK_LINES);
        }
    }
}

