/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.CreateMachinePopup;
import fr.frinn.custommachinery.client.screen.creation.DeleteMachinePopup;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineListSorting;
import fr.frinn.custommachinery.client.screen.creation.MachineListWidget;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import java.io.File;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class MachineCreationScreen
extends BaseScreen {
    private CycleButton<MachineListSorting> sorter;
    private MachineListWidget machineList;
    private Button create;
    private Button edit;
    private Button open;
    private Button delete;

    public MachineCreationScreen() {
        super((Component)Component.literal((String)"Machine creation"), 256, 192);
    }

    public void sort(MachineListSorting sorting) {
        CMConfig.CONFIG.sortMachineList.set((Object)sorting);
        CMConfig.CONFIG.sortMachineList.save();
        this.machineList.sort();
    }

    public void create() {
        this.openPopup(new CreateMachinePopup(this), "Creation popup");
    }

    public void edit() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            Minecraft.getInstance().setScreen((Screen)new MachineEditScreen(this, 288, 210, new CustomMachineBuilder(entry.getMachine())));
        }
    }

    public void open() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            try {
                File file = Objects.requireNonNull(entry.getMachine().getLocation().getFile((MinecraftServer)Minecraft.getInstance().getSingleplayerServer()));
                Util.getPlatform().openUri(file.toURI());
            }
            catch (NullPointerException e) {
                CustomMachinery.LOGGER.warn("Can't open machine json for machine: {}", (Object)entry.getMachine().getId());
            }
        }
    }

    public void delete() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            this.openPopup(new DeleteMachinePopup(this, entry.getMachine()), "Delete machine");
        }
    }

    public void reloadList() {
        this.machineList.reload();
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.x, this.y);
        layout.defaultCellSetting().padding(5);
        GridLayout.RowHelper row = layout.createRowHelper(4);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        this.sorter = (CycleButton)row.addChild((LayoutElement)CycleButton.builder(v -> Component.literal((String)v.name())).withValues((Object[])MachineListSorting.values()).displayOnlyValue().withInitialValue((Object)((MachineListSorting)((Object)CMConfig.CONFIG.sortMachineList.get()))).create(0, 0, 50, 20, (Component)Component.empty(), (button, sort) -> this.sort((MachineListSorting)((Object)sort))), 4, row.newCellSettings().alignHorizontallyLeft().paddingBottom(0));
        this.machineList = (MachineListWidget)row.addChild((LayoutElement)new MachineListWidget(0, 0, this.xSize - 10, this.ySize - 65, 30), 4, center);
        this.machineList.reload();
        this.create = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.create"), button -> this.create()).bounds(0, 0, 50, 20).build(), center);
        this.edit = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.edit"), button -> this.edit()).bounds(0, 0, 50, 20).build(), center);
        this.open = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.open"), button -> this.open()).bounds(0, 0, 50, 20).build(), center);
        this.delete = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.delete"), button -> this.delete()).bounds(0, 0, 50, 20).build(), center);
        layout.arrangeElements();
        layout.visitWidgets(this::addRenderableWidget);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        MachineCreationScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry == null) {
            Tooltip notSelected = Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.not_selected"));
            this.edit.active = false;
            this.edit.setTooltip(notSelected);
            this.open.active = false;
            this.open.setTooltip(notSelected);
            this.delete.active = false;
            this.delete.setTooltip(notSelected);
            return;
        }
        if (entry.getMachine().getLocation().canEdit()) {
            this.edit.active = true;
            this.edit.setTooltip(null);
            if (Minecraft.getInstance().getSingleplayerServer() != null) {
                this.open.active = true;
                this.open.setTooltip(null);
            } else {
                this.open.active = false;
                this.open.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.cant_open_server")));
            }
            this.delete.active = true;
            this.delete.setTooltip(null);
        } else {
            this.edit.active = false;
            this.edit.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.cant_edit")));
            this.open.active = false;
            this.open.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.cant_open")));
            this.delete.active = false;
            this.delete.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.cant_delete")));
        }
    }
}

