/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentPropertyListWidget;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentBuilderPopup<T extends IMachineComponentTemplate<?>>
extends PopupScreen {
    @Nullable
    private final T baseTemplate;
    private final Consumer<T> onFinish;
    private final Component title;
    public ComponentPropertyListWidget propertyList;
    public Button confirm;

    public ComponentBuilderPopup(BaseScreen parent, @Nullable T template, Consumer<T> onFinish, Component title) {
        super(parent, 256, 196);
        this.onFinish = onFinish;
        this.baseTemplate = template;
        this.title = title;
    }

    public abstract T makeTemplate();

    private void confirm() {
        this.onFinish.accept(this.makeTemplate());
        this.parent.closePopup(this);
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    public Optional<T> baseTemplate() {
        return Optional.ofNullable(this.baseTemplate);
    }

    public Component canCreate() {
        return Component.empty();
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget(new StringWidget(this.title, this.font)).setPosition(this.x + (this.xSize - this.font.width((FormattedText)this.title)) / 2, this.y + 5);
        this.propertyList = this.addRenderableWidget(new ComponentPropertyListWidget(this.x + 5, this.y + 15, this.xSize - 10, this.ySize - 50, 30));
        this.confirm = this.addRenderableWidget(Button.builder((Component)CONFIRM, b -> this.confirm()).bounds(this.x + this.xSize / 3 - 25, this.y + this.ySize - 30, 50, 20).build());
        this.addRenderableWidget(Button.builder((Component)CANCEL, b -> this.cancel()).bounds(this.x + this.xSize / 3 * 2 - 25, this.y + this.ySize - 30, 50, 20).build());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Component canCreate = this.canCreate();
        if (canCreate.getString().isEmpty()) {
            this.confirm.active = true;
        } else {
            this.confirm.active = false;
            if (this.confirm.isHovered()) {
                graphics.renderTooltip(this.font, canCreate, mouseX, mouseY);
            }
        }
    }

    public boolean checkLong(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public long parseLong(String s) {
        if (s.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

