/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ColorWidget;
import fr.frinn.custommachinery.client.screen.widget.config.AutoIOModeButton;
import fr.frinn.custommachinery.client.screen.widget.config.SideModeButton;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ComponentConfigBuilderWidget
extends Button {
    public static <T extends SideConfig.Template<?>> ComponentConfigBuilderWidget make(int x, int y, int width, int height, Component message, BaseScreen parent, Supplier<T> baseConfig, Consumer<T> onFinish) {
        return new ComponentConfigBuilderWidget(x, y, width, height, message, parent, baseConfig, onFinish);
    }

    private ComponentConfigBuilderWidget(int x, int y, int width, int height, Component message, BaseScreen parent, Supplier<SideConfig.Template<?>> baseConfig, Consumer<SideConfig.Template<?>> onFinish) {
        super(x, y, width, height, message, button -> parent.openPopup(new ComponentConfigBuilderPopup(parent, baseConfig, onFinish), "IO Config"), Button.DEFAULT_NARRATION);
    }

    public static class ComponentConfigBuilderPopup
    extends PopupScreen {
        private static final WidgetSprites ALL_NONE_SPRITES = new WidgetSprites(CustomMachinery.rl("config/all_none_button"), CustomMachinery.rl("config/all_none_button_hovered"));
        private static final WidgetSprites EXIT_SPRITES = new WidgetSprites(CustomMachinery.rl("config/exit_button"), CustomMachinery.rl("config/exit_button_hovered"));
        private static final Component TITLE = Component.translatable((String)"custommachinery.gui.config.component");
        private final Consumer<SideConfig.Template<?>> onFinish;
        private SideConfig.Template<?> template;

        public ComponentConfigBuilderPopup(BaseScreen parent, Supplier<SideConfig.Template<?>> baseConfig, Consumer<SideConfig.Template<?>> onFinish) {
            super(parent, 96, 145);
            this.template = baseConfig.get();
            this.onFinish = onFinish;
        }

        @Override
        protected void init() {
            super.init();
            this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 25, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.TOP), RelativeSide.TOP, button -> this.setSide(RelativeSide.TOP, true), button -> this.setSide(RelativeSide.TOP, false)));
            this.addRenderableWidget(new SideModeButton(this.x + 25, this.y + 41, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.LEFT), RelativeSide.LEFT, button -> this.setSide(RelativeSide.LEFT, true), button -> this.setSide(RelativeSide.LEFT, false)));
            this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 41, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.FRONT), RelativeSide.FRONT, button -> this.setSide(RelativeSide.FRONT, true), button -> this.setSide(RelativeSide.FRONT, false)));
            this.addRenderableWidget(new SideModeButton(this.x + 57, this.y + 41, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.RIGHT), RelativeSide.RIGHT, button -> this.setSide(RelativeSide.RIGHT, true), button -> this.setSide(RelativeSide.RIGHT, false)));
            this.addRenderableWidget(new SideModeButton(this.x + 25, this.y + 57, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.BACK), RelativeSide.BACK, button -> this.setSide(RelativeSide.BACK, true), button -> this.setSide(RelativeSide.BACK, false)));
            this.addRenderableWidget(new SideModeButton(this.x + 41, this.y + 57, () -> (SideConfig.SideMode)this.template.sides().get((Object)RelativeSide.BOTTOM), RelativeSide.BOTTOM, button -> this.setSide(RelativeSide.BOTTOM, true), button -> this.setSide(RelativeSide.BOTTOM, false)));
            if (this.template instanceof IOSideConfig.Template) {
                this.addRenderableWidget(new AutoIOModeButton(this.x + 18, this.y + 75, () -> ((IOSideConfig.Template)this.template).autoInput(), true, button -> this.setIO(true)));
                this.addRenderableWidget(new AutoIOModeButton(this.x + 50, this.y + 75, () -> ((IOSideConfig.Template)this.template).autoOutput(), false, button -> this.setIO(false)));
            }
            ImageButton allNone = this.addRenderableWidget(new ImageButton(this.x + 78, this.y + 57, 14, 14, ALL_NONE_SPRITES, button -> this.setAllNone()));
            allNone.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.config.all_none")));
            ImageButton close = this.addRenderableWidget(new ImageButton(this.x + 5, this.y + 5, 9, 9, EXIT_SPRITES, button -> this.parent.closePopup(this)));
            close.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.config.close")));
            StringWidget colorTitle = this.addRenderableWidget(new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.components.config.color"), this.font));
            colorTitle.setPosition(this.x + 35, this.y + 90);
            colorTitle.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.components.config.color.tooltip")));
            ColorWidget color = this.addRenderableWidget(new ColorWidget(0, 0, this.xSize - 10, 20, (Component)Component.empty(), () -> this.template.color().getARGB(), this::setColor, true));
            color.setPosition(this.x + 10, this.y + 100);
        }

        @Override
        public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderBackground(graphics, mouseX, mouseY, partialTicks);
            graphics.drawString(Minecraft.getInstance().font, TITLE, (int)((float)this.x + (float)this.xSize / 2.0f - (float)this.font.width((FormattedText)TITLE) / 2.0f), this.y + 5, 0, false);
        }

        @Override
        public void closed() {
            this.onFinish.accept(this.template);
        }

        private void setSide(RelativeSide side, boolean next) {
            SideConfig.Template<?> template = this.template;
            if (template instanceof IOSideConfig.Template) {
                IOSideConfig.Template ioTemplate = (IOSideConfig.Template)template;
                sides = new HashMap<RelativeSide, IOSideMode>(ioTemplate.sides());
                sides.put((RelativeSide)side, (ToggleSideMode)((Object)(next ? ioTemplate.sides().get((Object)side).next() : ioTemplate.sides().get((Object)side).previous())));
                this.template = new IOSideConfig.Template((Map<RelativeSide, IOSideMode>)sides, ioTemplate.autoInput(), ioTemplate.autoOutput(), ioTemplate.enabled(), ioTemplate.color());
            } else {
                sides = this.template;
                if (sides instanceof ToggleSideConfig.Template) {
                    ToggleSideConfig.Template toggleTemplate = (ToggleSideConfig.Template)sides;
                    sides = new HashMap<RelativeSide, ToggleSideMode>(toggleTemplate.sides());
                    sides.put((RelativeSide)side, (ToggleSideMode)(toggleTemplate.sides().get((Object)side) == ToggleSideMode.ENABLED ? ToggleSideMode.DISABLED : ToggleSideMode.ENABLED));
                    this.template = new ToggleSideConfig.Template((Map<RelativeSide, ToggleSideMode>)sides, toggleTemplate.enabled(), toggleTemplate.color());
                }
            }
        }

        private void setIO(boolean input) {
            SideConfig.Template<?> template = this.template;
            if (template instanceof IOSideConfig.Template) {
                IOSideConfig.Template ioTemplate = (IOSideConfig.Template)template;
                this.template = input ? new IOSideConfig.Template(ioTemplate.sides(), !ioTemplate.autoInput(), ioTemplate.autoOutput(), ioTemplate.enabled(), ioTemplate.color()) : new IOSideConfig.Template(ioTemplate.sides(), ioTemplate.autoInput(), !ioTemplate.autoOutput(), ioTemplate.enabled(), ioTemplate.color());
            }
        }

        private void setAllNone() {
            SideConfig.Template<?> template = this.template;
            if (template instanceof IOSideConfig.Template) {
                IOSideConfig.Template ioTemplate = (IOSideConfig.Template)template;
                this.template = new IOSideConfig.Template(new HashMap<RelativeSide, IOSideMode>(IOSideConfig.Template.DEFAULT_ALL_NONE.sides()), ioTemplate.autoInput(), ioTemplate.autoOutput(), ioTemplate.enabled(), ioTemplate.color());
            } else {
                template = this.template;
                if (template instanceof ToggleSideConfig.Template) {
                    ToggleSideConfig.Template toggleTemplate = (ToggleSideConfig.Template)template;
                    this.template = new ToggleSideConfig.Template(new HashMap<RelativeSide, ToggleSideMode>(ToggleSideConfig.Template.DEFAULT_ALL_DISABLED.sides()), toggleTemplate.enabled(), toggleTemplate.color());
                }
            }
        }

        private void setColor(int color) {
            SideConfig.Template<?> template = this.template;
            if (template instanceof IOSideConfig.Template) {
                IOSideConfig.Template ioTemplate = (IOSideConfig.Template)template;
                this.template = new IOSideConfig.Template(ioTemplate.sides(), ioTemplate.autoInput(), ioTemplate.autoOutput(), ioTemplate.enabled(), Color.fromARGB(color));
            } else {
                template = this.template;
                if (template instanceof ToggleSideConfig.Template) {
                    ToggleSideConfig.Template toggleTemplate = (ToggleSideConfig.Template)template;
                    this.template = new ToggleSideConfig.Template(toggleTemplate.sides(), toggleTemplate.enabled(), Color.fromARGB(color));
                }
            }
        }
    }
}

