/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.upgrade.tabs;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.creation.upgrade.UpgradeEditScreen;
import fr.frinn.custommachinery.client.screen.creation.upgrade.tabs.UpgradeEditTab;
import fr.frinn.custommachinery.client.screen.widget.GridListWidget;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class MachinesTab
extends UpgradeEditTab {
    public MachinesTab(UpgradeEditScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.tab.machines"), parent);
        GridLayout.RowHelper row = this.layout.rowSpacing(8).createRowHelper(1);
        row.defaultCellSetting().paddingHorizontal(0).paddingTop(10);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.machines.title"), Minecraft.getInstance().font), center);
        MachineSelectionList list = (MachineSelectionList)row.addChild((LayoutElement)new MachineSelectionList(0, 0, 250, 200, id -> {
            if (parent.getBuilder().getMachines().contains(id)) {
                parent.getBuilder().getMachines().remove(id);
            } else {
                parent.getBuilder().getMachines().add((ResourceLocation)id);
            }
            parent.setChanged();
        }), center);
        list.getAll().forEach(entry -> {
            if (parent.getBuilder().getMachines().contains(entry.machine)) {
                entry.selected = true;
            }
        });
    }

    private static class MachineSelectionList
    extends GridListWidget<MachineEntry> {
        public MachineSelectionList(int x, int y, int width, int height, Consumer<ResourceLocation> onClick) {
            super(x, y, width, height);
            CustomMachinery.MACHINES.keySet().forEach(id -> this.addEntry(new MachineEntry((ResourceLocation)id, onClick)));
        }

        private static class MachineEntry
        extends GridListWidget.Entry {
            private static final Component SELECT = Component.translatable((String)"custommachinery.gui.creation.upgrade.machines.select").withStyle(ChatFormatting.DARK_RED);
            private static final Component UNSELECT = Component.translatable((String)"custommachinery.gui.creation.upgrade.machines.unselect").withStyle(ChatFormatting.DARK_RED);
            private final ResourceLocation machine;
            private final ItemStack machineStack;
            private final Consumer<ResourceLocation> onClick;
            private boolean selected = false;

            private MachineEntry(ResourceLocation machine, Consumer<ResourceLocation> onClick) {
                this.machine = machine;
                this.machineStack = CustomMachineItem.makeMachineItem(machine);
                this.onClick = onClick;
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                if (this.selected) {
                    graphics.fill(0, 0, 18, 18, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
                }
                graphics.renderItem(this.machineStack, 1, 1);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                this.selected = !this.selected;
                this.onClick.accept(this.machine);
                return true;
            }

            @Override
            public List<Component> getTooltips() {
                List tooltips = this.machineStack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.NORMAL);
                if (this.selected) {
                    tooltips.add(UNSELECT);
                } else {
                    tooltips.add(SELECT);
                }
                return tooltips;
            }

            public List<? extends GuiEventListener> children() {
                return Collections.emptyList();
            }
        }
    }
}

