/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.DropRequirement;
import net.minecraft.world.item.Items;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Drop")
public interface DropRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T checkDrop(IItemStack item, int radius) {
        return this.checkDrops((IIngredient)item, item.amount(), radius, true);
    }

    @ZenCodeType.Method
    default public T checkAnyDrop(int amount, int radius) {
        return this.checkDrops((IIngredient)IItemStack.empty(), amount, radius, false);
    }

    @ZenCodeType.Method
    default public T checkDrops(IIngredient items, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CHECK, items.asVanillaIngredient(), whitelist, Items.AIR, amount, radius));
    }

    @ZenCodeType.Method
    default public T consumeDropOnStart(IItemStack item, int radius) {
        return this.consumeDropsOnStart((IIngredient)item, item.amount(), radius, true);
    }

    @ZenCodeType.Method
    default public T consumeAnyDropOnStart(int amount, int radius) {
        return this.consumeDropsOnStart((IIngredient)IItemStack.empty(), amount, radius, false);
    }

    @ZenCodeType.Method
    default public T consumeDropsOnStart(IIngredient items, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CONSUME, items.asVanillaIngredient(), whitelist, Items.AIR, amount, radius));
    }

    @ZenCodeType.Method
    default public T consumeDropOnEnd(IItemStack item, int radius) {
        return this.consumeDropsOnEnd((IIngredient)item, item.amount(), radius, true);
    }

    @ZenCodeType.Method
    default public T consumeAnyDropOnEnd(int amount, int radius) {
        return this.consumeDropsOnEnd((IIngredient)IItemStack.empty(), amount, radius, false);
    }

    @ZenCodeType.Method
    default public T consumeDropsOnEnd(IIngredient ingredient, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.CONSUME, ingredient.asVanillaIngredient(), whitelist, Items.AIR, amount, radius));
    }

    @ZenCodeType.Method
    default public T dropItemOnStart(IItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.PRODUCE, IItemStack.empty().asVanillaIngredient(), true, stack.getDefinition(), stack.amount(), 1));
    }

    @ZenCodeType.Method
    default public T dropItemOnEnd(IItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.PRODUCE, IItemStack.empty().asVanillaIngredient(), true, stack.getDefinition(), stack.amount(), 1));
    }
}

