/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.EntityRequirement;
import java.util.Arrays;
import net.minecraft.world.entity.EntityType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Entity")
public interface EntityRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireEntities(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CHECK_AMOUNT, amount, radius, Arrays.asList(filter), whitelist));
    }

    @ZenCodeType.Method
    default public T requireEntitiesHealth(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CHECK_HEALTH, amount, radius, Arrays.asList(filter), whitelist));
    }

    @ZenCodeType.Method
    default public T consumeEntityHealthOnStart(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.CONSUME_HEALTH, amount, radius, Arrays.asList(filter), whitelist));
    }

    @ZenCodeType.Method
    default public T consumeEntityHealthOnEnd(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.OUTPUT, EntityRequirement.ACTION.CONSUME_HEALTH, amount, radius, Arrays.asList(filter), whitelist));
    }

    @ZenCodeType.Method
    default public T killEntityOnStart(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.INPUT, EntityRequirement.ACTION.KILL, amount, radius, Arrays.asList(filter), whitelist));
    }

    @ZenCodeType.Method
    default public T killEntityOnEnd(int amount, int radius, @ZenCodeType.Optional EntityType[] filter, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        return this.addRequirement(new EntityRequirement(RequirementIOMode.OUTPUT, EntityRequirement.ACTION.KILL, amount, radius, Arrays.asList(filter), whitelist));
    }
}

