/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder;

import com.google.common.collect.ImmutableMap;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MachineAppearanceBuilder {
    @Nullable
    private final MachineStatus status;
    private final Map<MachineAppearanceProperty<?>, Object> properties;

    public MachineAppearanceBuilder(@Nullable MachineStatus status) {
        this.status = status;
        this.properties = new HashMap(MachineAppearance.defaultProperties());
    }

    public MachineAppearanceBuilder(Map<MachineAppearanceProperty<?>, Object> properties, @Nullable MachineStatus status) {
        this.status = status;
        HashMap map = new HashMap();
        for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
            if (!properties.containsKey(property) || properties.get(property) == null) {
                map.put(property, property.getDefaultValue());
                continue;
            }
            map.put(property, properties.get(property));
        }
        this.properties = map;
    }

    @Nullable
    public MachineStatus getStatus() {
        return this.status;
    }

    public <T> T getProperty(MachineAppearanceProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            return property.getDefaultValue();
        }
        return (T)this.properties.get(property);
    }

    public <T> void setProperty(MachineAppearanceProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public void reset() {
        this.properties.clear();
        this.properties.putAll(MachineAppearance.defaultProperties());
    }

    public MachineAppearance build() {
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)ImmutableMap.copyOf(this.properties));
    }
}

