/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.upgrade.Operation;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import net.minecraft.network.chat.Component;

public record CoreModifier(Operation operation, double modifier, int max, int min, Component tooltip) {
    public static final NamedCodec<CoreModifier> CODEC = NamedCodec.record(modifierInstance -> modifierInstance.group(Operation.CODEC.fieldOf("operation").forGetter(modifier -> modifier.operation), NamedCodec.DOUBLE.fieldOf("modifier").forGetter(modifier -> modifier.modifier), NamedCodec.intRange(1, 32).optionalFieldOf("max", 32).forGetter(modifier -> modifier.max), NamedCodec.intRange(1, 32).optionalFieldOf("min", 1).forGetter(modifier -> modifier.min), TextComponentUtils.CODEC.optionalFieldOf("tooltip", (Component)Component.empty()).forGetter(modifier -> modifier.tooltip)).apply((Applicative)modifierInstance, CoreModifier::new), "Core modifier");

    public CoreModifier(Operation operation, double modifier, int max, int min, Component tooltip) {
        this.operation = operation;
        this.modifier = modifier;
        this.max = max;
        this.min = min;
        this.tooltip = tooltip != null && !tooltip.getString().isEmpty() ? tooltip : this.getDefaultTooltip();
    }

    public double apply(double original, int upgradeAmount) {
        return this.operation.apply(original, this.modifier, upgradeAmount, this.min, this.max);
    }

    private Component getDefaultTooltip() {
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case Operation.ADDITION -> Component.literal((String)((this.modifier >= 0.0 ? "+" : "") + this.modifier + " cores"));
            case Operation.MULTIPLICATION, Operation.EXPONENTIAL -> {
                double tooltipModifier = this.modifier * 100.0 - 100.0;
                yield Component.literal((String)((tooltipModifier >= 0.0 ? "+" : "") + tooltipModifier + "% cores"));
            }
        };
    }
}

