/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.transfer;

import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SidedEnergyStorage
implements IEnergyStorage {
    private final Direction side;
    private final EnergyMachineComponent component;

    public SidedEnergyStorage(Direction side, EnergyMachineComponent component) {
        this.side = side;
        this.component = component;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return ((IOSideMode)this.component.getConfig().getDirectionMode(this.side)).isInput() ? this.component.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return ((IOSideMode)this.component.getConfig().getDirectionMode(this.side)).isOutput() ? this.component.extractEnergy(maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        return Utils.toInt(this.component.getEnergy());
    }

    public int getMaxEnergyStored() {
        return Utils.toInt(this.component.getCapacity());
    }

    public boolean canExtract() {
        return ((IOSideMode)this.component.getConfig().getDirectionMode(this.side)).isOutput();
    }

    public boolean canReceive() {
        return ((IOSideMode)this.component.getConfig().getDirectionMode(this.side)).isInput();
    }
}

