/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.client.builder;

import com.simibubi.create.AllBlocks;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.FloatSlider;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinerycreate.Registration;
import fr.frinn.custommachinerycreate.components.ContraptionMachineComponent;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ContraptionComponentBuilder
implements IMachineComponentBuilder<ContraptionMachineComponent, ContraptionMachineComponent.Template> {
    public MachineComponentType<ContraptionMachineComponent> type() {
        return Registration.CONTRAPTION_MACHINE_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen parent, @Nullable ContraptionMachineComponent.Template template, Consumer<ContraptionMachineComponent.Template> onFinish) {
        return new ContraptionComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, ContraptionMachineComponent.Template template) {
        graphics.renderFakeItem(AllBlocks.COGWHEEL.asItem().getDefaultInstance(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
    }

    public static class ContraptionComponentBuilderPopup
    extends ComponentBuilderPopup<ContraptionMachineComponent.Template> {
        private FloatSlider stressImpact;
        private ToggleSideConfig.Template config;

        public ContraptionComponentBuilderPopup(BaseScreen parent, @Nullable ContraptionMachineComponent.Template template, Consumer<ContraptionMachineComponent.Template> onFinish) {
            super(parent, (IMachineComponentTemplate)template, onFinish, (Component)Component.translatable((String)"custommachinerycreate.gui.creation.components.contraption"));
        }

        public ContraptionMachineComponent.Template makeTemplate() {
            return new ContraptionMachineComponent.Template(this.stressImpact.floatValue(), this.config);
        }

        protected void init() {
            super.init();
            this.stressImpact = (FloatSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerycreate.gui.creation.components.contraption.stress_impact"), (AbstractWidget)FloatSlider.builder().decimalsToShow(2).bounds(0.0f, 128.0f).displayOnlyValue().create(0, 0, 160, 20, (Component)Component.translatable((String)"custommachinerycreate.gui.creation.components.contraption.stress_impact")));
            this.baseTemplate().ifPresentOrElse(template -> this.stressImpact.setValue(template.stressImpact()), () -> this.stressImpact.setValue(0.0f));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config();
            }, () -> {
                this.config = ToggleSideConfig.Template.DEFAULT_ALL_ENABLED;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), (AbstractWidget)ComponentConfigBuilderWidget.make((int)0, (int)0, (int)160, (int)20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), (BaseScreen)this.parent, () -> this.config, template -> {
                this.config = template;
            }));
        }
    }
}

