/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinerycreate.Registration;
import fr.frinn.custommachinerycreate.util.FakeGeneratingKineticBlockEntity;
import net.minecraft.network.chat.Component;

public class ContraptionMachineComponent
extends AbstractMachineComponent
implements ITickableComponent,
ISideConfigComponent {
    private final float baseStressImpact;
    private final ToggleSideConfig config;
    private final FakeGeneratingKineticBlockEntity fakeTile;
    private float speed;
    private float stressCapacity;
    private float stressImpact;
    private int resetTimer = 0;

    public ContraptionMachineComponent(IMachineComponentManager manager) {
        this(manager, 0.0f, ToggleSideConfig.Template.DEFAULT_ALL_ENABLED);
    }

    public ContraptionMachineComponent(IMachineComponentManager manager, float baseStressImpact, ToggleSideConfig.Template config) {
        super(manager, ComponentIOMode.BOTH);
        this.baseStressImpact = baseStressImpact;
        this.config = config.build((ISideConfigComponent)this);
        MachineTile be = manager.getTile();
        this.fakeTile = new FakeGeneratingKineticBlockEntity(be.getType(), be.getBlockPos(), be.getBlockState(), this);
        if (manager.getLevel() != null) {
            this.fakeTile.setLevel(manager.getLevel());
        }
        this.fakeTile.reActivateSource = true;
    }

    public FakeGeneratingKineticBlockEntity getFakeTile() {
        return this.fakeTile;
    }

    public void set(float speed, float stressCapacity, float stressApplied) {
        this.speed = speed;
        this.stressCapacity = stressCapacity;
        this.stressImpact = stressApplied;
        this.applyChanges();
        this.resetTimer = -1;
    }

    public void markForReset() {
        this.resetTimer = 2;
    }

    private void applyChanges() {
        this.fakeTile.setGeneratedSpeed(this.speed);
        this.fakeTile.setStressCapacity(this.stressCapacity);
        this.fakeTile.setStressImpact(this.stressImpact);
        this.fakeTile.reActivateSource = true;
    }

    public MachineComponentType<ContraptionMachineComponent> getType() {
        return Registration.CONTRAPTION_MACHINE_COMPONENT.get();
    }

    public ToggleSideConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return "contraption";
    }

    public void serverTick() {
        if (this.resetTimer >= 0 && this.resetTimer-- == 0) {
            this.speed = 0.0f;
            this.stressCapacity = 0.0f;
            this.stressImpact = this.baseStressImpact;
            this.applyChanges();
        }
        this.fakeTile.tick();
    }

    public void onStatusChanged(MachineStatus oldStatus, MachineStatus newStatus, Component message) {
        if (newStatus != MachineStatus.RUNNING) {
            this.fakeTile.setGeneratedSpeed(0.0f);
            this.fakeTile.setStressCapacity(0.0f);
            this.fakeTile.reActivateSource = true;
        } else {
            this.applyChanges();
        }
    }

    public void init() {
        this.fakeTile.setLevel(this.getManager().getLevel());
    }

    public void onRemoved() {
        if (this.getManager().getTile().isUnloaded()) {
            this.fakeTile.onChunkUnloaded();
        }
        this.fakeTile.setRemoved();
    }

    public record Template(float stressImpact, ToggleSideConfig.Template config) implements IMachineComponentTemplate<ContraptionMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("stress_impact", (Object)Float.valueOf(0.0f)).forGetter(template -> Float.valueOf(template.stressImpact)), (App)ToggleSideConfig.Template.CODEC.optionalFieldOf("config", (Object)ToggleSideConfig.Template.DEFAULT_ALL_ENABLED).forGetter(template -> template.config)).apply((Applicative)templateInstance, Template::new), (String)"Contraption machine component");

        public MachineComponentType<ContraptionMachineComponent> getType() {
            return Registration.CONTRAPTION_MACHINE_COMPONENT.get();
        }

        public String getId() {
            return "contraption";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return false;
        }

        public ContraptionMachineComponent build(IMachineComponentManager manager) {
            return new ContraptionMachineComponent(manager, this.stressImpact, this.config);
        }
    }
}

