/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerycreate.integration.kubejs;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinerycreate.requirements.ContraptionRequirement;

public interface ContraptionRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requireSU(float speed) {
        return this.requireSU(speed, 0.0f);
    }

    default public RecipeJSBuilder requireSU(float speed, float stressImpact) {
        return this.addContraptionRequirement(RequirementIOMode.INPUT, speed, stressImpact, false);
    }

    default public RecipeJSBuilder requireScalingSU(float speed) {
        return this.requireScalingSU(speed, 0.0f);
    }

    default public RecipeJSBuilder requireScalingSU(float speed, float stressImpact) {
        return this.addContraptionRequirement(RequirementIOMode.INPUT, speed, stressImpact, true);
    }

    default public RecipeJSBuilder produceSU(float speed) {
        return this.produceSU(speed, 0.0f);
    }

    default public RecipeJSBuilder produceSU(float speed, float stressCapacity) {
        return this.addContraptionRequirement(RequirementIOMode.OUTPUT, speed, stressCapacity, false);
    }

    default public RecipeJSBuilder addContraptionRequirement(RequirementIOMode mode, float speed, float stress, boolean scaling) {
        if (speed < 0.0f) {
            return this.error("Speed value cannot be negative: {}", new Object[]{Float.valueOf(speed)});
        }
        if (stress < 0.0f) {
            return this.error("Stress value cannot be negative: {}", new Object[]{Float.valueOf(stress)});
        }
        if (scaling && mode == RequirementIOMode.OUTPUT) {
            return this.error("Scaling can only be enabled in input mode", new Object[0]);
        }
        return this.addRequirement(new ContraptionRequirement(mode, speed, stress, scaling));
    }
}

