/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client;

import fr.frinn.custommachinery.api.guielement.RegisterGuiElementWidgetSupplierEvent;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.api.integration.jei.RegisterGuiElementJEIRendererEvent;
import fr.frinn.custommachinery.api.integration.jei.RegisterWidgetToJeiIngredientGetterEvent;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.creation.component.RegisterComponentBuilderEvent;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.RegisterGuiElementBuilderEvent;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.integration.jei.WidgetToJeiIngredientRegistry;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.client.jei.element.ChemicalGuiElementJeiRenderer;
import fr.frinn.custommachinerymekanism.client.jei.element.HeatGuiElementJeiRenderer;
import fr.frinn.custommachinerymekanism.client.render.element.ChemicalGuiElementWidget;
import fr.frinn.custommachinerymekanism.client.render.element.HeatGuiElementWidget;
import fr.frinn.custommachinerymekanism.client.screen.creation.component.ChemicalComponentBuilder;
import fr.frinn.custommachinerymekanism.client.screen.creation.component.HeatComponentBuilder;
import fr.frinn.custommachinerymekanism.client.screen.creation.gui.ChemicalGuiElementBuilder;
import fr.frinn.custommachinerymekanism.client.screen.creation.gui.HeatGuiElementBuilder;
import fr.frinn.custommachinerymekanism.common.component.ChemicalMachineComponent;
import fr.frinn.custommachinerymekanism.common.guielement.ChemicalGuiElement;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="custommachinerymekanism", value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void registerGuiElementWidgets(RegisterGuiElementWidgetSupplierEvent event) {
        event.register(Registration.CHEMICAL_GUI_ELEMENT.get(), ChemicalGuiElementWidget::new);
        event.register(Registration.HEAT_GUI_ELEMENT.get(), HeatGuiElementWidget::new);
    }

    @SubscribeEvent
    public static void registerComponentBuilders(RegisterComponentBuilderEvent event) {
        event.register(Registration.HEAT_MACHINE_COMPONENT.get(), (IMachineComponentBuilder)new HeatComponentBuilder());
        event.register(Registration.CHEMICAL_MACHINE_COMPONENT.get(), (IMachineComponentBuilder)new ChemicalComponentBuilder());
    }

    @SubscribeEvent
    public static void registerGuiElementBuilders(RegisterGuiElementBuilderEvent event) {
        event.register(Registration.HEAT_GUI_ELEMENT.get(), (IGuiElementBuilder)new HeatGuiElementBuilder());
        event.register(Registration.CHEMICAL_GUI_ELEMENT.get(), (IGuiElementBuilder)new ChemicalGuiElementBuilder());
    }

    @SubscribeEvent
    public static void registerGuiElementJeiRenderers(RegisterGuiElementJEIRendererEvent event) {
        event.register(Registration.CHEMICAL_GUI_ELEMENT.get(), (IJEIElementRenderer)new ChemicalGuiElementJeiRenderer());
        event.register(Registration.HEAT_GUI_ELEMENT.get(), (IJEIElementRenderer)new HeatGuiElementJeiRenderer());
    }

    @SubscribeEvent
    public static void registerWidgetToJeiIngredientGetters(RegisterWidgetToJeiIngredientGetterEvent event) {
        event.register(Registration.CHEMICAL_GUI_ELEMENT.get(), (WidgetToJeiIngredientRegistry.IngredientGetter)new ChemicalIngredientGetter());
    }

    private static class ChemicalIngredientGetter
    implements WidgetToJeiIngredientRegistry.IngredientGetter<ChemicalGuiElement, ChemicalStack> {
        private ChemicalIngredientGetter() {
        }

        @Nullable
        public IClickableIngredient<ChemicalStack> getIngredient(final AbstractGuiElementWidget<ChemicalGuiElement> widget, double mouseX, double mouseY, IJeiHelpers helpers) {
            ChemicalMachineComponent component = widget.getScreen().getTile().getComponentManager().getComponentHandler(Registration.CHEMICAL_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(((ChemicalGuiElement)widget.getElement()).getComponentId())).orElse(null);
            if (component == null) {
                return null;
            }
            return helpers.getIngredientManager().createTypedIngredient((Object)component.getStack()).map(ingredient -> new IClickableIngredient<ChemicalStack>(){

                public ITypedIngredient<ChemicalStack> getTypedIngredient() {
                    return ingredient;
                }

                public ChemicalStack getIngredient() {
                    return (ChemicalStack)ingredient.getIngredient();
                }

                public IIngredientType<ChemicalStack> getIngredientType() {
                    return MekanismJEI.TYPE_CHEMICAL;
                }

                public Rect2i getArea() {
                    return new Rect2i(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
                }
            }).orElse(null);
        }
    }
}

