/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public abstract class ConfigProperty {
    protected final String name;
    protected boolean showOnHud = true;
    protected UUID uniqueName = null;
    private Supplier<Component> displayName;
    private Supplier<Component> toolTip;
    protected PropertyProvider provider;
    public static final Codec<ConfigProperty> CODEC = new PropertyCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfigProperty> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ConfigProperty>(){

        public ConfigProperty decode(RegistryFriendlyByteBuf buf) {
            Type type = (Type)((Object)Type.STREAM_CODEC.decode((Object)buf));
            return (ConfigProperty)type.getStreamCodec().decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ConfigProperty property) {
            Type.STREAM_CODEC.encode((Object)buf, (Object)property.getType());
            property.getType().getStreamCodec().encode((Object)buf, (Object)property);
        }
    };

    public ConfigProperty(String name) {
        this.name = name;
    }

    public ConfigProperty(String name, Component displayName) {
        this.name = name;
        this.displayName = () -> displayName;
    }

    public ConfigProperty(String name, boolean showOnHud, Optional<UUID> uniqueName) {
        this.name = name;
        this.showOnHud = showOnHud;
        this.uniqueName = uniqueName.orElse(null);
    }

    public abstract ConfigProperty copy();

    public void setProvider(PropertyProvider provider) {
        this.provider = provider;
    }

    public PropertyProvider getProvider() {
        return this.provider;
    }

    public void setDisplayName(Supplier<Component> displayName) {
        this.displayName = displayName;
    }

    public void setToolTip(Supplier<Component> toolTip) {
        this.toolTip = toolTip;
    }

    public Component getDisplayName() {
        return this.displayName == null ? Component.translatable((String)("item_prop.draconicevolution." + this.name)) : this.displayName.get();
    }

    public Component getToolTip() {
        return this.toolTip == null ? Component.translatable((String)("item_prop.draconicevolution." + this.name + ".info")) : this.toolTip.get();
    }

    public abstract Component getDisplayValue();

    public String getName() {
        return this.uniqueName == null ? this.name : this.uniqueName.toString();
    }

    public void generateUnique() {
        this.uniqueName = UUID.randomUUID();
    }

    public UUID getUniqueName() {
        return this.uniqueName;
    }

    protected Optional<UUID> getOptionalUniqueName() {
        return Optional.ofNullable(this.uniqueName);
    }

    public abstract void onValueChanged(ItemStack var1);

    public abstract void validateValue();

    public abstract Type getType();

    public boolean showOnHud() {
        return this.showOnHud;
    }

    public void setShowOnHud(boolean showOnHud) {
        this.showOnHud = showOnHud;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigProperty)) {
            return false;
        }
        ConfigProperty that = (ConfigProperty)o;
        return this.showOnHud == that.showOnHud && Objects.equals(this.name, that.name) && Objects.equals(this.uniqueName, that.uniqueName);
    }

    public boolean equalsWOValue(Object o) {
        if (!(o instanceof ConfigProperty)) {
            return false;
        }
        ConfigProperty that = (ConfigProperty)o;
        return this.showOnHud == that.showOnHud && Objects.equals(this.name, that.name) && Objects.equals(this.uniqueName, that.uniqueName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.showOnHud, this.uniqueName);
    }

    public abstract void loadData(PropertyData var1, ItemStack var2);

    public static class PropertyCodec
    implements Codec<ConfigProperty> {
        public <T> DataResult<Pair<ConfigProperty, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
                DecoderState decoder = new DecoderState(ops);
                stream.accept(decoder::accept);
                return decoder.build();
            });
        }

        public <T> DataResult<T> encode(ConfigProperty input, DynamicOps<T> ops, T prefix) {
            ListBuilder builder = ops.listBuilder();
            builder.add(Type.CODEC.encodeStart(ops, (Object)input.getType()));
            builder.add(input.getType().getCodec().encodeStart(ops, (Object)input));
            return builder.build(prefix);
        }

        private static class DecoderState<T> {
            private final DynamicOps<T> ops;
            private final Stream.Builder<T> failed = Stream.builder();
            private int count;
            private Type type = null;
            private ConfigProperty property = null;

            private DecoderState(DynamicOps<T> ops) {
                this.ops = ops;
            }

            public void accept(T value) {
                ++this.count;
                if (this.type == null) {
                    DataResult elementResult = Type.CODEC.decode(this.ops, value);
                    elementResult.error().ifPresent(error -> this.failed.add(value));
                    elementResult.resultOrPartial().ifPresent(e -> {
                        this.type = (Type)((Object)((Object)e.getFirst()));
                    });
                } else {
                    DataResult elementResult = this.type.getCodec().decode(this.ops, value);
                    elementResult.error().ifPresent(error -> this.failed.add(value));
                    elementResult.resultOrPartial().ifPresent(e -> {
                        this.property = (ConfigProperty)e.getFirst();
                    });
                }
            }

            public DataResult<Pair<ConfigProperty, T>> build() {
                if (this.count != 2) {
                    return DataResult.error(() -> "ConfigProperty is invalid. Read: " + this.count + " inputs, expected is 2");
                }
                Object errors = this.ops.createList(this.failed.build());
                return DataResult.success((Object)Pair.of((Object)this.property, (Object)errors), (Lifecycle)Lifecycle.stable());
            }
        }
    }

    public static enum DecimalFormatter implements StringRepresentable
    {
        RAW_0(e -> String.valueOf(e.intValue())),
        RAW_1(e -> String.format("%.1f", e)),
        RAW_2(e -> String.format("%.2f", e)),
        RAW_3(e -> String.format("%.3f", e)),
        RAW_4(e -> String.format("%.4f", e)),
        PERCENT_0(e -> String.format("%.0f%%", e * 100.0)),
        PERCENT_1(e -> String.format("%.1f%%", e * 100.0)),
        PERCENT_2(e -> String.format("%.2f%%", e * 100.0)),
        PLUS_PERCENT_0(e -> String.format("+%.0f%%", e * 100.0)),
        PLUS_PERCENT_1(e -> String.format("+%.1f%%", e * 100.0)),
        PLUS_PERCENT_2(e -> String.format("+%.2f%%", e * 100.0)),
        AOE_0(e -> String.format("%.0fx%.0f", 1.0 + e * 2.0, 1.0 + e * 2.0)),
        AOE_1(e -> String.format("%.1fx%.1f", 1.0 + e * 2.0, 1.0 + e * 2.0)),
        AOE_2(e -> String.format("%.2fx%.2f", 1.0 + e * 2.0, 1.0 + e * 2.0));

        public static final Codec<DecimalFormatter> CODEC;
        public static final IntFunction<DecimalFormatter> BY_ID;
        public static final StreamCodec<ByteBuf, DecimalFormatter> STREAM_CODEC;
        private Function<Double, String> formatter;

        private DecimalFormatter(Function<Double, String> formatter) {
            this.formatter = formatter;
        }

        public String format(double value) {
            return this.formatter.apply(value);
        }

        public static DecimalFormatter getSafe(int index) {
            return index >= 0 && index < DecimalFormatter.values().length ? DecimalFormatter.values()[index] : RAW_1;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(DecimalFormatter::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DecimalFormatter.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum IntegerFormatter implements StringRepresentable
    {
        RAW(String::valueOf),
        AOE(e -> String.format("%sx%s", 1 + e * 2, 1 + e * 2));

        public static final Codec<IntegerFormatter> CODEC;
        public static final IntFunction<IntegerFormatter> BY_ID;
        public static final StreamCodec<ByteBuf, IntegerFormatter> STREAM_CODEC;
        private Function<Integer, String> formatter;

        private IntegerFormatter(Function<Integer, String> formatter) {
            this.formatter = formatter;
        }

        public String format(int value) {
            return this.formatter.apply(value);
        }

        public static IntegerFormatter getSafe(int index) {
            return index >= 0 && index < IntegerFormatter.values().length ? IntegerFormatter.values()[index] : RAW;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(IntegerFormatter::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])IntegerFormatter.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum BooleanFormatter implements StringRepresentable
    {
        TRUE_FALSE(e -> Component.translatable((String)("gui.draconicevolution.boolean_property." + (e != false ? "true" : "false")))),
        ENABLED_DISABLED(e -> Component.translatable((String)("gui.draconicevolution.boolean_property." + (e != false ? "enabled" : "disabled")))),
        ACTIVE_INACTIVE(e -> Component.translatable((String)("gui.draconicevolution.boolean_property." + (e != false ? "active" : "inactive")))),
        YES_NO(e -> Component.translatable((String)("gui.draconicevolution.boolean_property." + (e != false ? "yes" : "no"))));

        public static final Codec<BooleanFormatter> CODEC;
        public static final IntFunction<BooleanFormatter> BY_ID;
        public static final StreamCodec<ByteBuf, BooleanFormatter> STREAM_CODEC;
        private Function<Boolean, Component> formatter;

        private BooleanFormatter(Function<Boolean, Component> formatter) {
            this.formatter = formatter;
        }

        public Component format(boolean value) {
            return this.formatter.apply(value);
        }

        public static BooleanFormatter getSafe(int index) {
            return index >= 0 && index < BooleanFormatter.values().length ? BooleanFormatter.values()[index] : TRUE_FALSE;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(BooleanFormatter::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])BooleanFormatter.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum Type implements StringRepresentable
    {
        BOOLEAN(BooleanProperty.CODEC, BooleanProperty.STREAM_CODEC),
        INTEGER(IntegerProperty.CODEC, IntegerProperty.STREAM_CODEC),
        DECIMAL(DecimalProperty.CODEC, DecimalProperty.STREAM_CODEC);

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        public static final IntFunction<Type> BY_ID;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        private final Codec<? extends ConfigProperty> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, ? extends ConfigProperty> streamCodec;

        private Type(Codec<? extends ConfigProperty> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends ConfigProperty> streamCodec) {
            this.codec = codec;
            this.streamCodec = streamCodec;
        }

        public Codec<ConfigProperty> getCodec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConfigProperty> getStreamCodec() {
            return this.streamCodec;
        }

        public static Type getSafe(int index) {
            return index >= 0 && index < Type.values().length ? Type.values()[index] : BOOLEAN;
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

