/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.particle.IntParticleData;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.StructureBlock;
import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class TileEnergyPylon
extends TileBCore
implements MultiBlockController {
    private static final VoxelShape SPHERE_SHAPE = Shapes.box((double)0.2, (double)0.2, (double)0.2, (double)0.8, (double)0.8, (double)0.8);
    public final ManagedEnum<EnergyPylon.Mode> ioMode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("io_mode", (Enum)EnergyPylon.Mode.OUTPUT, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<Direction> direction = (ManagedEnum)this.register((IManagedData)new ManagedEnum("direction", (Enum)Direction.UP, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<EnumColour> colour = (ManagedEnum)this.register((IManagedData)new ManagedEnum("colour", EnumColour.class, null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool structureValid = (ManagedBool)this.register((IManagedData)new ManagedBool("structure_valid", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedPos coreOffset = (ManagedPos)this.register((IManagedData)new ManagedPos("core_offset", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedByte particleRate = (ManagedByte)this.register((IManagedData)new ManagedByte("particle_rate", new DataFlags[]{DataFlags.SYNC_TILE}));
    private TileEnergyCore core = null;
    private int coreSelection = 0;
    private int tick = 0;
    private int lastCompOverride = 0;
    public IOPStorage opAdapter = new IOPStorage(){

        public boolean canExtract() {
            return ((EnergyPylon.Mode)TileEnergyPylon.this.ioMode.get()).canExtract();
        }

        public boolean canReceive() {
            return ((EnergyPylon.Mode)TileEnergyPylon.this.ioMode.get()).canReceive();
        }

        public long receiveOP(long maxReceive, boolean simulate) {
            if (TileEnergyPylon.this.coreOffset.isNull() || !this.canReceive() || TileEnergyPylon.this.getCore() == null || !TileEnergyPylon.this.core.active.get()) {
                return 0L;
            }
            long received = TileEnergyPylon.this.core.energy.receiveOP(maxReceive, simulate);
            if (!simulate && received > 0L) {
                TileEnergyPylon.this.particleRate.set((int)((byte)Math.min(20L, received < 500L ? 1L : received / 500L)));
            }
            return received;
        }

        public long extractOP(long maxExtract, boolean simulate) {
            if (TileEnergyPylon.this.coreOffset.isNull() || !this.canExtract() || TileEnergyPylon.this.getCore() == null || !TileEnergyPylon.this.core.active.get()) {
                return 0L;
            }
            long extracted = TileEnergyPylon.this.core.energy.extractOP(maxExtract, simulate);
            if (!simulate && extracted > 0L) {
                TileEnergyPylon.this.particleRate.set((int)((byte)Math.min(20L, extracted < 500L ? 1L : extracted / 500L)));
            }
            return extracted;
        }

        public long getOPStored() {
            return TileEnergyPylon.this.coreOffset.notNull() && TileEnergyPylon.this.getCore() != null ? TileEnergyPylon.this.core.energy.getOPStored() : 0L;
        }

        public long getMaxOPStored() {
            return TileEnergyPylon.this.coreOffset.notNull() && TileEnergyPylon.this.getCore() != null ? TileEnergyPylon.this.core.energy.getMaxOPStored() : 0L;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (int)this.receiveOP(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (int)this.extractOP(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return (int)Math.min(this.getOPStored(), 0x3FFFFFFFL);
        }

        public int getMaxEnergyStored() {
            return (int)Math.min(this.getMaxOPStored(), Integer.MAX_VALUE);
        }

        public long modifyEnergyStored(long amount) {
            return 0L;
        }
    };

    public TileEnergyPylon(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_ENERGY_PYLON.get(), pos, state);
        this.capManager.set(CapabilityOP.BLOCK, (Object)this.opAdapter, new Direction[0]);
        this.enableTileDebug();
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileEnergyPylon.energyCapability((RegisterCapabilitiesEvent)event, DEContent.TILE_ENERGY_PYLON);
    }

    public void tick() {
        long extracted;
        super.tick();
        if (!this.structureValid.get() || this.coreOffset.isNull() || this.getCore() == null || !this.core.active.get()) {
            return;
        }
        if (this.tick++ % 10 == 0 && this.opAdapter.getMaxOPStored() > 0L) {
            this.updateComparators();
        }
        if (!this.level.isClientSide && ((EnergyPylon.Mode)this.ioMode.get()).canExtract() && (extracted = this.core.energy.extractOP(this.sendEnergyToAll(this.core.energy.getUncappedStored(), this.core.energy.getUncappedStored()), false)) > 0L) {
            this.particleRate.set((int)((byte)Math.min(20L, extracted < 500L ? 1L : extracted / 500L)));
        }
        if (this.level.isClientSide) {
            this.spawnParticles();
        }
        if (!this.level.isClientSide && (this.particleRate.get() > 1 || this.particleRate.get() > 0 && this.level.random.nextInt(2) == 0)) {
            this.particleRate.subtract(2);
        }
    }

    public void updateComparators() {
        int cOut = 0;
        if (this.getCore() != null) {
            cOut = (int)((double)this.core.energy.getUncappedStored() / (double)this.core.energy.getMaxOPStored() * 15.0);
        }
        if (cOut != this.lastCompOverride) {
            this.lastCompOverride = cOut;
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    @Override
    public InteractionResult handleRemoteClick(Player player, BlockHitResult hit) {
        if (!this.level.isClientSide) {
            this.ioMode.set((Enum)((EnergyPylon.Mode)this.ioMode.get()).reverse());
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue(EnergyPylon.MODE, (Comparable)((Object)((EnergyPylon.Mode)this.ioMode.get()))));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public TileEnergyCore getCore() {
        BlockPos pos = this.coreOffset.get();
        if (pos != null) {
            BlockPos corePos = this.worldPosition.subtract((Vec3i)pos);
            LevelChunk coreChunk = this.level.getChunkAt(corePos);
            if (!this.level.isAreaLoaded(corePos, 16)) {
                this.core = null;
                return null;
            }
            BlockEntity tileAtPos = coreChunk.getBlockEntity(corePos, LevelChunk.EntityCreationType.CHECK);
            if (tileAtPos == null || this.core == null || tileAtPos != this.core) {
                BlockEntity tile = this.level.getBlockEntity(corePos);
                if (tile instanceof TileEnergyCore) {
                    this.core = (TileEnergyCore)tile;
                } else {
                    this.core = null;
                    if (!this.level.isClientSide()) {
                        this.coreOffset.set(null);
                    }
                }
            }
        }
        return this.core;
    }

    private List<TileEnergyCore> findActiveCores() {
        LinkedList<TileEnergyCore> list = new LinkedList<TileEnergyCore>();
        int range = 18;
        Direction dir = (Direction)this.direction.get();
        BlockPos offset = new BlockPos(dir.getStepX() * range, dir.getStepY() * range, dir.getStepZ() * range);
        BlockPos min = this.worldPosition.offset(-18, -18, -18).offset((Vec3i)offset);
        BlockPos max = this.worldPosition.offset(18, 18, 18).offset((Vec3i)offset);
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            BlockEntity blockEntity;
            if (!this.level.getBlockState(blockPos).is((Block)DEContent.ENERGY_CORE.get()) || !((blockEntity = this.level.getBlockEntity(blockPos)) instanceof TileEnergyCore)) continue;
            TileEnergyCore tile = (TileEnergyCore)blockEntity;
            if (!tile.active.get()) continue;
            list.add(tile);
        }
        return list;
    }

    public void selectNextCore() {
        if (this.level.isClientSide) {
            return;
        }
        List<TileEnergyCore> cores = this.findActiveCores();
        if (cores.isEmpty()) {
            this.core = null;
            this.coreOffset.set(null);
            return;
        }
        if (this.coreSelection >= cores.size()) {
            this.coreSelection = 0;
        }
        TileEnergyCore selectedCore = cores.get(this.coreSelection);
        this.coreOffset.set(new BlockPos((Vec3i)this.worldPosition.subtract((Vec3i)selectedCore.getBlockPos())));
        this.core = selectedCore;
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        ++this.coreSelection;
        this.detectAndSendChanges(false);
        this.drawParticleBeam();
    }

    @Override
    public boolean validateStructure() {
        this.debug("ValidateStructure, IsValid: " + this.structureValid.get());
        if (!this.structureValid.get()) {
            boolean found = false;
            for (Direction dir : Direction.values()) {
                BlockPos pos = this.worldPosition.relative(dir);
                BlockState testState = this.level.getBlockState(pos);
                if (!testState.is(Tags.Blocks.GLASS_BLOCKS)) continue;
                this.colour.set((Enum)TileEnergyPylon.getGlassColour(testState));
                StructureBlock.buildingLock = true;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)EnergyPylon.FACING, (Comparable)dir));
                this.level.setBlockAndUpdate(pos, ((StructureBlock)((Object)DEContent.STRUCTURE_BLOCK.get())).defaultBlockState());
                StructureBlock.buildingLock = false;
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof TileStructureBlock)) continue;
                TileStructureBlock tile = (TileStructureBlock)blockEntity;
                tile.blockName.set(BuiltInRegistries.BLOCK.getKey((Object)testState.getBlock()));
                tile.setController(this);
                this.direction.set((Enum)dir);
                found = true;
                break;
            }
            this.debug("Glass block found: " + found);
            if (!found) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)EnergyPylon.FACING, (Comparable)Direction.UP));
                this.colour.set(null);
            }
        }
        this.structureValid.set(this.isStructureValid());
        this.debug("Validate Result: " + this.structureValid.get());
        if (this.structureValid.get() && this.coreOffset.isNull()) {
            this.selectNextCore();
        } else if (!this.structureValid.get() && this.coreOffset.notNull()) {
            this.coreOffset.set(null);
        }
        return this.structureValid.get();
    }

    @Override
    public boolean isStructureValid() {
        return this.isGlass(this.worldPosition.relative((Direction)this.direction.get()));
    }

    private boolean isGlass(BlockPos pos) {
        TileStructureBlock tile;
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        return blockEntity instanceof TileStructureBlock && (tile = (TileStructureBlock)blockEntity).getOriginalBlock().defaultBlockState().is(Tags.Blocks.GLASS_BLOCKS);
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 0) {
            this.drawParticleBeam();
        }
    }

    public void drawParticleBeam() {
        if (!this.level.isClientSide) {
            this.sendPacketToChunk(mcDataOutput -> {}, 0);
            return;
        }
        if (this.getCore() == null) {
            return;
        }
        BlockPos thisPos = this.worldPosition.relative((Direction)this.direction.get());
        Vec3D coreVec = Vec3D.getDirectionVec((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)new Vec3D(this.core.getBlockPos()).add(0.5, 0.5, 0.5));
        double coreDistance = Utils.getDistance((Vec3D)new Vec3D(thisPos).add(0.5, 0.5, 0.5), (Vec3D)Vec3D.getCenter((BlockPos)this.core.getBlockPos()));
        for (int i = 0; i < 100; ++i) {
            double location = (double)i / 100.0;
            Vec3D particlePos = new Vec3D(thisPos).add(0.5, 0.5, 0.5);
            particlePos.add(coreVec.x * coreDistance * location, coreVec.y * coreDistance * location, coreVec.z * coreDistance * location);
            double speed = 0.02f;
            double offset = 0.2f;
            double randX = this.level.random.nextDouble() - 0.5;
            double randY = this.level.random.nextDouble() - 0.5;
            double randZ = this.level.random.nextDouble() - 0.5;
            particlePos.add(randX * offset, randY * offset, randZ * offset);
            this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.LINE_INDICATOR.get(), new Integer[]{150, 0, 255, 40 + this.level.random.nextInt(20)}), particlePos.x, particlePos.y, particlePos.z, randX * speed, randY * speed, randZ * speed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        RandomSource rand = this.level.random;
        if (this.getCore() == null || this.particleRate.get() <= 0) {
            return;
        }
        if (this.particleRate.get() > 20) {
            this.particleRate.set(20);
        }
        int r = 0;
        int g = 200;
        int b = 255;
        if (this.colour.notNull()) {
            r = (int)(((EnumColour)this.colour.get()).rF() * 255.0f);
            g = (int)(((EnumColour)this.colour.get()).gF() * 255.0f);
            b = (int)(((EnumColour)this.colour.get()).bF() * 255.0f);
        }
        if (this.particleRate.get() > 10) {
            for (int i = 0; i <= this.particleRate.get() / 10; ++i) {
                Vec3D spawn = this.getParticleSpawn(rand);
                Vec3D dest = this.getParticleDest(rand);
                this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY.get(), new Integer[]{r, g, b, 200}), spawn.x, spawn.y, spawn.z, dest.x, dest.y, dest.z);
            }
        } else if (rand.nextInt(Math.max(1, 10 - this.particleRate.get())) == 0) {
            Vec3D spawn = this.getParticleSpawn(rand);
            Vec3D dest = this.getParticleDest(rand);
            this.level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY.get(), new Integer[]{r, g, b, 200}), spawn.x, spawn.y, spawn.z, dest.x, dest.y, dest.z);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3D getParticleSpawn(RandomSource random) {
        if (((EnergyPylon.Mode)this.ioMode.get()).canExtract()) {
            double range = this.core.tier.get();
            return new Vec3D(this.core.getBlockPos()).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
        }
        return Vec3D.getCenter((BlockPos)this.worldPosition.relative((Direction)this.direction.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3D getParticleDest(RandomSource random) {
        if (((EnergyPylon.Mode)this.ioMode.get()).canExtract()) {
            return Vec3D.getCenter((BlockPos)this.worldPosition.relative((Direction)this.direction.get()));
        }
        double range = (double)this.core.tier.get() / 2.0;
        return new Vec3D(this.core.getBlockPos()).add(0.5, 0.5, 0.5).add((double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range, (double)(random.nextFloat() - 0.5f) * range);
    }

    @Override
    public VoxelShape getShapeForPart(BlockPos pos, CollisionContext context) {
        return SPHERE_SHAPE;
    }

    @Override
    public boolean renderSelectionBox(RenderHighlightEvent.Block event) {
        return false;
    }

    @Nullable
    public static EnumColour getGlassColour(BlockState state) {
        if (state.is(Tags.Blocks.DYED_WHITE)) {
            return EnumColour.WHITE;
        }
        if (state.is(Tags.Blocks.DYED_ORANGE)) {
            return EnumColour.ORANGE;
        }
        if (state.is(Tags.Blocks.DYED_MAGENTA)) {
            return EnumColour.MAGENTA;
        }
        if (state.is(Tags.Blocks.DYED_LIGHT_BLUE)) {
            return EnumColour.LIGHT_BLUE;
        }
        if (state.is(Tags.Blocks.DYED_YELLOW)) {
            return EnumColour.YELLOW;
        }
        if (state.is(Tags.Blocks.DYED_LIME)) {
            return EnumColour.LIME;
        }
        if (state.is(Tags.Blocks.DYED_PINK)) {
            return EnumColour.PINK;
        }
        if (state.is(Tags.Blocks.DYED_GRAY)) {
            return EnumColour.GRAY;
        }
        if (state.is(Tags.Blocks.DYED_LIGHT_GRAY)) {
            return EnumColour.LIGHT_GRAY;
        }
        if (state.is(Tags.Blocks.DYED_CYAN)) {
            return EnumColour.CYAN;
        }
        if (state.is(Tags.Blocks.DYED_PURPLE)) {
            return EnumColour.PURPLE;
        }
        if (state.is(Tags.Blocks.DYED_BLUE)) {
            return EnumColour.BLUE;
        }
        if (state.is(Tags.Blocks.DYED_BROWN)) {
            return EnumColour.BROWN;
        }
        if (state.is(Tags.Blocks.DYED_GREEN)) {
            return EnumColour.GREEN;
        }
        if (state.is(Tags.Blocks.DYED_RED)) {
            return EnumColour.RED;
        }
        if (state.is(Tags.Blocks.DYED_BLACK)) {
            return EnumColour.BLACK;
        }
        return null;
    }
}

