/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.handlers.EntityAttributeHandler;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.Nullable;

public class ModularArmorEventHandler {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public static final ResourceLocation WALK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"walk_speed");
    public static final ResourceLocation STEP_HEIGHT_ID = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"step_height");
    public static final ResourceLocation FLY_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"fly_speed");
    public static final ResourceLocation SUBMERGED_MINE_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"aqua_speed");
    public static final EntityAttributeHandler<ArmorAbilities> ATTRIBUTE_HANDLER = new EntityAttributeHandler();
    public static Map<Player, Boolean> playersWithFlight = new WeakHashMap<Player, Boolean>();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::onEntityAttacked);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::onEntityDamaged);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onEntityFall);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, ModularArmorEventHandler::onEntityDeath);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::livingTick);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onLivingJumpEvent);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, ModularArmorEventHandler::breakSpeed);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::onPlayerLogin);
        NeoForge.EVENT_BUS.addListener(ModularArmorEventHandler::blockBreakEvent);
        ATTRIBUTE_HANDLER.register(WALK_SPEED_ID, () -> Attributes.MOVEMENT_SPEED, ModularArmorEventHandler::getWalkSpeedAttribute);
        ATTRIBUTE_HANDLER.register(FLY_SPEED_ID, () -> Attributes.FLYING_SPEED, ModularArmorEventHandler::getFlightSpeedAttribute);
        ATTRIBUTE_HANDLER.register(STEP_HEIGHT_ID, () -> Attributes.STEP_HEIGHT, ModularArmorEventHandler::getStepHeight);
        ATTRIBUTE_HANDLER.register(SUBMERGED_MINE_SPEED_ID, () -> Attributes.SUBMERGED_MINING_SPEED, ModularArmorEventHandler::getSubmergedMiningSpeed);
    }

    @Nullable
    private static AttributeModifier getWalkSpeedAttribute(LivingEntity entity, ArmorAbilities abilities) {
        if (abilities.data == null) {
            return null;
        }
        double speedModifier = abilities.data.speedMultiplier();
        if (entity.isSprinting() && abilities.speedSettingRun != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSettingRun);
        } else if (abilities.speedSetting != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSetting);
        }
        if (speedModifier > 0.0) {
            return new AttributeModifier(WALK_SPEED_ID, speedModifier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }
        return null;
    }

    @Nullable
    private static AttributeModifier getFlightSpeedAttribute(LivingEntity entity, ArmorAbilities abilities) {
        if (abilities.data == null) {
            return null;
        }
        double speedModifier = abilities.data.speedMultiplier();
        if (entity.isSprinting() && abilities.speedSettingRun != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSettingRun);
        } else if (abilities.speedSetting != -1.0) {
            speedModifier = Math.min(speedModifier, abilities.speedSetting);
        }
        if (speedModifier > 0.0) {
            return new AttributeModifier(FLY_SPEED_ID, speedModifier / 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        }
        return null;
    }

    @Nullable
    private static AttributeModifier getStepHeight(LivingEntity entity, ArmorAbilities abilities) {
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = DECapabilities.getHost(chestStack);
        boolean hasHost = !chestStack.isEmpty() && host != null;
        boolean hasHighStep = hasHost && host.getEntitiesByType(ModuleTypes.HILL_STEP).findAny().isPresent() && !entity.isShiftKeyDown();
        AttributeInstance instance = entity.getAttribute(Attributes.STEP_HEIGHT);
        if (hasHighStep && instance != null) {
            double modifier = instance.getValue();
            if (modifier > 1.0 && instance.getModifier(STEP_HEIGHT_ID) == null) {
                return null;
            }
            if (instance.hasModifier(STEP_HEIGHT_ID)) {
                modifier -= instance.getModifier(STEP_HEIGHT_ID).amount();
            }
            if ((modifier = 1.1625 - modifier) > 0.0) {
                return new AttributeModifier(STEP_HEIGHT_ID, modifier, AttributeModifier.Operation.ADD_VALUE);
            }
        }
        return null;
    }

    @Nullable
    private static AttributeModifier getSubmergedMiningSpeed(LivingEntity entity, ArmorAbilities abilities) {
        ItemStack chestStack = IModularArmor.getArmor(entity);
        ModuleHost host = DECapabilities.getHost(chestStack);
        boolean hasHost = !chestStack.isEmpty() && host != null;
        boolean hasAquaAdapt = hasHost && host.getModuleData(ModuleTypes.AQUA_ADEPT) != null && !entity.isShiftKeyDown();
        AttributeInstance instance = entity.getAttribute(Attributes.SUBMERGED_MINING_SPEED);
        if (hasAquaAdapt && instance != null) {
            double modifier = instance.getValue();
            if (modifier >= 1.0) {
                return null;
            }
            if (instance.hasModifier(SUBMERGED_MINE_SPEED_ID)) {
                modifier -= instance.getModifier(SUBMERGED_MINE_SPEED_ID).amount();
            }
            if ((modifier = 1.0 - modifier) > 0.0) {
                return new AttributeModifier(SUBMERGED_MINE_SPEED_ID, modifier, AttributeModifier.Operation.ADD_VALUE);
            }
        }
        return null;
    }

    private static void breakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        float newDigSpeed = event.getOriginalSpeed();
        ItemStack chestStack = IModularArmor.getArmor((LivingEntity)player);
        ModuleHost host = DECapabilities.getHost(chestStack);
        if (host == null) {
            return;
        }
        if (!player.onGround() && host.getModuleData(ModuleTypes.MINING_STABILITY) != null) {
            newDigSpeed *= 5.0f;
        }
        if (newDigSpeed != event.getOriginalSpeed()) {
            event.setNewSpeed(newDigSpeed);
        }
    }

    private static void onEntityAttacked(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCanceled() || event.getAmount() <= 0.0f || entity.level().isClientSide || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor(entity);
        try (ModuleHost host = DECapabilities.getHost(chestStack);){
            if (chestStack.isEmpty() || host == null) {
                return;
            }
            if (event.getAmount() == Float.MAX_VALUE && event.getSource().is(DamageTypes.FELL_OUT_OF_WORLD)) {
                event.setCanceled(true);
                entity.hurt(DEDamage.killDamage(entity.level()), 6.805647E37f);
                return;
            }
            if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
                return;
            }
            ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
            if (shieldControl == null) {
                return;
            }
            shieldControl.tryBlockDamage(event);
        }
    }

    private static void onEntityDamaged(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (event.getNewDamage() <= 0.0f || entity.level().isClientSide || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor(entity);
        try (ModuleHost host = DECapabilities.getHost(chestStack);){
            if (chestStack.isEmpty() || host == null) {
                return;
            }
            if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
                return;
            }
            ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
            if (shieldControl == null) {
                return;
            }
            shieldControl.tryBlockDamage(event);
        }
    }

    private static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, true);
        if (jumpBoost > 0.0f) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (jumpBoost *= 2.0f)));
        }
    }

    private static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.isCanceled() || entity.level().isClientSide) {
            return;
        }
        HashMap<UndyingEntity, ModuleHost> undyingModules = new HashMap<UndyingEntity, ModuleHost>();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            NonNullList nonNullList = player.getInventory().items;
            for (int i = 0; i < nonNullList.size(); ++i) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)nonNullList.get(i), undyingModules, (EquipmentSlot)(player.getInventory().selected == i ? EquipmentSlot.MAINHAND : null), false, (HolderLookup.Provider)entity.registryAccess());
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)player.getInventory().armor.get(slot.getIndex()), undyingModules, slot, false, (HolderLookup.Provider)entity.registryAccess());
            }
            for (ItemStack stack : player.getInventory().offhand) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, EquipmentSlot.OFFHAND, false, (HolderLookup.Provider)entity.registryAccess());
            }
            for (ItemStack stack : EquipmentManager.getAllItems(entity)) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, null, true, (HolderLookup.Provider)entity.registryAccess());
            }
        } else if (EquipmentManager.equipModLoaded()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.getUndyingEntities(entity.getItemBySlot(slot), undyingModules, slot, true, (HolderLookup.Provider)entity.registryAccess());
            }
        }
        if (undyingModules.isEmpty() || event.getSource().is(DEDamage.KILL)) {
            return;
        }
        for (Map.Entry entry : undyingModules.entrySet()) {
            if (!((UndyingEntity)entry.getKey()).tryBlockDeath(event)) continue;
            ((ModuleHost)entry.getValue()).save();
            event.setCanceled(true);
            return;
        }
    }

    private static void getUndyingEntities(ItemStack stack, Map<UndyingEntity, ModuleHost> entities, EquipmentSlot slot, boolean inEquipModSlot, HolderLookup.Provider provider) {
        ModuleHost host = DECapabilities.getHost(stack);
        if (!stack.isEmpty() && stack.getItem() instanceof IModularItem && ((IModularItem)stack.getItem()).isEquipped(stack, slot, inEquipModSlot) && host != null) {
            host.getModuleEntities().stream().filter(e -> e instanceof UndyingEntity).map(e -> (UndyingEntity)e).forEach(undyingEntity -> entities.put((UndyingEntity)undyingEntity, host));
        }
    }

    private static void livingTick(EntityTickEvent.Pre event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ArmorAbilities armorAbilities = new ArmorAbilities();
        if (entity2 instanceof Player) {
            player = (Player)entity2;
            NonNullList stacks = player.getInventory().items;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.tryTickStack((ItemStack)stacks.get(i), (LivingEntity)player, (EquipmentSlot)(player.getInventory().selected == i ? EquipmentSlot.MAINHAND : null), armorAbilities, false);
            }
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.tryTickStack((ItemStack)player.getInventory().armor.get(slot.getIndex()), (LivingEntity)player, slot, armorAbilities, false);
            }
            for (ItemStack stack2 : player.getInventory().offhand) {
                ModularArmorEventHandler.tryTickStack(stack2, (LivingEntity)player, EquipmentSlot.OFFHAND, armorAbilities, false);
            }
            if (EquipmentManager.equipModLoaded()) {
                EquipmentManager.findItems(e -> e.getItem() instanceof IModularItem, entity2).forEach(stack -> ModularArmorEventHandler.tryTickStack(stack, (LivingEntity)player, null, armorAbilities, true));
            }
        } else {
            for (NonNullList slot : EquipmentSlot.values()) {
                ModularArmorEventHandler.tryTickStack(entity2.getItemBySlot((EquipmentSlot)slot), entity2, (EquipmentSlot)slot, armorAbilities, false);
            }
        }
        if (!entity2.level().isClientSide() && TimeKeeper.getServerTick() % 10 == 0) {
            ATTRIBUTE_HANDLER.updateEntity(entity2, armorAbilities);
        } else if (!entity2.level().isClientSide() && entity2 instanceof Player) {
            ATTRIBUTE_HANDLER.updateEntity(entity2, armorAbilities);
        }
        if (entity2 instanceof Player) {
            player = (Player)entity2;
            boolean canFly = true;
            boolean noPower = false;
            if (armorAbilities.creativeFlight && armorAbilities.flightPower != null && !player.getAbilities().instabuild && !player.isSpectator()) {
                canFly = armorAbilities.flightPower.get().getOPStored() >= (long)EquipCfg.creativeFlightEnergy;
                boolean bl = noPower = !canFly;
                if (canFly && player.getAbilities().flying && !entity2.level().isClientSide) {
                    armorAbilities.flightPower.get().modifyEnergyStored((long)(-EquipCfg.creativeFlightEnergy));
                }
            }
            if (armorAbilities.creativeFlight && canFly) {
                player.getAbilities().mayfly = true;
                playersWithFlight.put(player, true);
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !entity2.level().isClientSide) {
                    playersWithFlight.put(player, false);
                    if (!player.getAbilities().instabuild && !player.isSpectator()) {
                        boolean wasFlying = player.getAbilities().flying;
                        player.getAbilities().mayfly = false;
                        player.getAbilities().flying = false;
                        player.onUpdateAbilities();
                        if (wasFlying && noPower) {
                            player.tryToStartFallFlying();
                        }
                    }
                }
                if (player.level().isClientSide && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.getAbilities().instabuild) {
                        player.getAbilities().mayfly = false;
                        player.getAbilities().flying = false;
                    }
                }
            }
        }
    }

    private static float getJumpBoost(LivingEntity entity, boolean max) {
        ItemStack chestStack = IModularArmor.getArmor(entity);
        try (ModuleHost host = DECapabilities.getHost(chestStack);){
            JumpData jumpData;
            if (host != null && (jumpData = host.getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
                double jump = jumpData.multiplier();
                if (max) {
                    float f = (float)jump;
                    return f;
                }
                if (entity.isSprinting()) {
                    if (host instanceof PropertyProvider && host.hasDecimal("jump_boost_run")) {
                        jump = Math.min(jump, host.getDecimal("jump_boost_run").getValue());
                    }
                } else if (host instanceof PropertyProvider && host.hasDecimal("jump_boost")) {
                    jump = Math.min(jump, host.getDecimal("jump_boost").getValue());
                }
                float f = (float)jump;
                return f;
            }
        }
        return 0.0f;
    }

    private static void tryTickStack(ItemStack stack, LivingEntity entity, EquipmentSlot slot, ArmorAbilities abilities, boolean equipMod) {
        Item item = stack.getItem();
        if (item instanceof IModularItem) {
            IModularItem modularItem = (IModularItem)item;
            try (ModuleHost host = DECapabilities.getHost(stack);){
                if (host == null) {
                    return;
                }
                modularItem.handleTick(host, stack, entity, slot, equipMod);
                if (slot != null && slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR || equipMod) {
                    ModularArmorEventHandler.gatherArmorProps(stack, host, entity, abilities);
                }
            }
        }
    }

    private static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, false);
        if (jumpBoost > 0.0f && !entity.isShiftKeyDown()) {
            entity.push(0.0, (double)(0.1f * (jumpBoost + 1.0f)), 0.0);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.onGround()) {
            return;
        }
        ItemStack chestStack = IModularArmor.getArmor((LivingEntity)player);
        try (ModuleHost host = DECapabilities.getHost(chestStack);){
            FlightData flightData;
            if (host != null && (flightData = host.getModuleData(ModuleTypes.FLIGHT)) != null && flightData.creative()) {
                player.getAbilities().flying = true;
                player.onUpdateAbilities();
            }
        }
    }

    private static void blockBreakEvent(BlockEvent.BreakEvent event) {
        Item item;
        ItemStack stack = event.getPlayer().getMainHandItem();
        if (event.isCanceled() || !((item = stack.getItem()) instanceof IModularMiningTool)) {
            return;
        }
        IModularMiningTool miningTool = (IModularMiningTool)item;
        if (miningTool.onBlockStartBreak(stack, event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    private static void gatherArmorProps(ItemStack stack, ModuleHost host, LivingEntity entity, ArmorAbilities abilities) {
        FlightEntity flight;
        SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
        if (speed != null) {
            abilities.addSpeedData(speed, host);
        }
        if ((flight = (FlightEntity)host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null)) != null) {
            abilities.addFlightData(flight, () -> (IOPStorage)stack.getCapability(CapabilityOP.ITEM));
        }
    }

    public static class ArmorAbilities {
        private double speedSetting = -1.0;
        private double speedSettingRun = -1.0;
        private SpeedData data;
        private boolean elytraFlight = false;
        private boolean creativeFlight = false;
        private Supplier<IOPStorage> flightPower = null;

        private void addSpeedData(SpeedData data, ModuleHost host) {
            SpeedData speedData = this.data = this.data == null ? data : this.data.combine(data);
            if (host instanceof PropertyProvider) {
                if (host.hasDecimal("run_speed")) {
                    if (this.speedSettingRun == -1.0) {
                        this.speedSettingRun = 0.0;
                    }
                    this.speedSettingRun += host.getDecimal("run_speed").getValue();
                }
                if (host.hasDecimal("walk_speed")) {
                    if (this.speedSetting == -1.0) {
                        this.speedSetting = 0.0;
                    }
                    this.speedSetting += host.getDecimal("walk_speed").getValue();
                }
            }
        }

        private void addFlightData(FlightEntity entity, Supplier<IOPStorage> flightPower) {
            this.elytraFlight = this.elytraFlight || entity.getElytraEnabled();
            boolean bl = this.creativeFlight = this.creativeFlight || entity.getCreativeEnabled();
            if (flightPower != null && flightPower.get() != null && (this.flightPower == null || flightPower.get().getOPStored() > this.flightPower.get().getOPStored())) {
                this.flightPower = flightPower;
            }
        }
    }
}

