/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.inventory.container.modular.ModularSlot;
import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.IdentityProvider;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.inventory.ModularMenuCommon;
import com.google.common.collect.Streams;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ConfigurableItemMenu
extends ModularGuiContainerMenu
implements ModularMenuCommon {
    private static final UUID DEFAULT_UUID = UUID.fromString("d12b41e3-16ce-4653-ab36-1cd913719af8");
    private UUID selectedIdentity;
    private Runnable onInventoryChange;
    private Consumer<Boolean> onSelectionMade;
    private ItemStack stackCache = ItemStack.EMPTY;
    public final SlotGroup main = this.createSlotGroup(0, new int[0]);
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[0]);
    public final SlotGroup armor = this.createSlotGroup(0, new int[0]);
    public final SlotGroup offhand = this.createSlotGroup(0, new int[0]);
    public final SlotGroup curios = this.createSlotGroup(0, new int[0]);
    private boolean initialSync = false;
    private UUID lastSelected = null;

    public ConfigurableItemMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, PlayerSlot.fromBuff((ByteBuf)extraData));
    }

    public ConfigurableItemMenu(int windowId, Inventory playerInv, PlayerSlot slot) {
        super((MenuType)DEContent.MENU_CONFIGURABLE_ITEM.get(), windowId, playerInv);
        this.main.addPlayerMain(playerInv);
        this.hotBar.addPlayerBar(playerInv);
        this.armor.addPlayerArmor(playerInv);
        this.offhand.addPlayerOffhand(playerInv);
        EquipmentManager.getEquipmentInventory((LivingEntity)playerInv.player).ifPresent(handler -> this.curios.addSlots(handler.getSlots(), 0, i -> new ModularSlot((IItemHandler)handler, i.intValue())));
        IdentityProvider.resolveDuplicateIdentities(this.getInventoryStacks(), (HolderLookup.Provider)playerInv.player.registryAccess());
        UUID found = this.getIdentity(slot.getStackInSlot(playerInv.player), (HolderLookup.Provider)playerInv.player.registryAccess());
        if (found != null) {
            this.stackCache = slot.getStackInSlot(playerInv.player);
        }
        this.selectedIdentity = found == null ? DEFAULT_UUID : found;
    }

    @Override
    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setOnInventoryChange(Runnable onInventoryChange) {
        this.onInventoryChange = onInventoryChange;
    }

    public void setSelectionListener(Consumer<Boolean> onSelectionMade) {
        this.onSelectionMade = onSelectionMade;
    }

    public void clicked(int slotId, int button, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.slots.size() && (slot = (Slot)this.slots.get(slotId)) != null && !slot.getItem().isEmpty()) {
            try (ModuleHost provider = DECapabilities.getHost(slot.getItem());){
                if (provider != null && clickTypeIn == ClickType.PICKUP && button == 0 && player.containerMenu.getCarried().isEmpty()) {
                    this.selectedIdentity = provider.getIdentity();
                    if (this.onSelectionMade != null) {
                        this.onSelectionMade.accept(false);
                    }
                    this.stackCache = slot.getItem();
                    return;
                }
            }
        }
        if (this.onInventoryChange != null) {
            this.onInventoryChange.run();
        }
        super.clicked(slotId, button, clickTypeIn, player);
    }

    public UUID getSelectedIdentity() {
        return this.selectedIdentity;
    }

    public static Stream<ItemStack> getPlayerInventory(Inventory player) {
        return Streams.concat((Stream[])new Stream[]{player.items.stream(), player.armor.stream(), player.offhand.stream(), EquipmentManager.getAllItems((LivingEntity)player.player).stream()}).filter(e -> !e.isEmpty());
    }

    public static Stream<Pair<ItemStack, ModuleHost>> getStackProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> Pair.of((Object)e, (Object)DECapabilities.getHost(e))).filter(e -> e.value() != null);
    }

    public static void handlePropertyData(Player player, PropertyData data) {
        if (data.isGlobal) {
            ConfigurableItemMenu.getStackProviders(ConfigurableItemMenu.getPlayerInventory(player.getInventory())).filter(e -> ((ModuleHost)e.value()).getProviderName().equals(data.providerName)).map(e -> Pair.of((Object)((ItemStack)e.key()), (Object)((ModuleHost)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).forEach(e -> {
                ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key());
                ((ConfigProperty)e.value()).getProvider().close();
            });
        } else {
            ConfigurableItemMenu.getStackProviders(ConfigurableItemMenu.getPlayerInventory(player.getInventory())).filter(e -> ((ModuleHost)e.value()).getIdentity().equals(data.providerID)).map(e -> Pair.of((Object)((ItemStack)e.key()), (Object)((ModuleHost)e.value()).getProperty(data.getPropertyName()))).filter(e -> Objects.nonNull(e.value())).filter(e -> ((ConfigProperty)e.value()).getType() == data.type).findAny().ifPresent(e -> {
                ((ConfigProperty)e.value()).loadData(data, (ItemStack)e.key());
                ((ConfigProperty)e.value()).getProvider().close();
            });
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public void initializeContents(int stateId, List<ItemStack> stacks, ItemStack carried) {
        super.initializeContents(stateId, stacks, carried);
        this.onSyncDataReceived();
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    public void setItem(int slotID, int stateId, ItemStack stack) {
        super.setItem(slotID, stateId, stack);
        this.onSyncDataReceived();
    }

    private void onSyncDataReceived() {
        if (!this.initialSync) {
            this.initialSync = true;
            if (this.onSelectionMade != null) {
                this.onSelectionMade.accept(true);
            }
        }
        if (this.selectedIdentity != this.lastSelected || this.findProvider(this.selectedIdentity, (HolderLookup.Provider)this.inventory.player.registryAccess()) == null) {
            this.lastSelected = this.selectedIdentity;
            if (this.onInventoryChange != null) {
                this.onInventoryChange.run();
            }
        }
    }

    public ItemStack getLastStack() {
        return this.stackCache;
    }

    public static void tryOpenGui(ServerPlayer sender) {
        ItemStack stack = sender.getMainHandItem();
        if (!stack.isEmpty() && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            PlayerSlot slot = new PlayerSlot((Player)sender, InteractionHand.MAIN_HAND);
            sender.openMenu((MenuProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        PlayerSlot slot = PlayerSlot.findStackActiveFirst((Inventory)sender.getInventory(), e -> e.getCapability(DECapabilities.Host.ITEM) != null);
        if (slot != null) {
            sender.openMenu((MenuProvider)new Provider(slot), arg_0 -> ((PlayerSlot)slot).toBuff(arg_0));
            return;
        }
        sender.sendSystemMessage((Component)Component.translatable((String)"gui.draconicevolution.item_config.no_configurable_items").withStyle(ChatFormatting.RED));
    }

    public static class Provider
    implements MenuProvider {
        private PlayerSlot slot;

        public Provider(PlayerSlot slot) {
            this.slot = slot;
        }

        public Component getDisplayName() {
            return Component.translatable((String)"gui.draconicevolution.item_config.name");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int menuID, Inventory playerInventory, Player playerEntity) {
            return new ConfigurableItemMenu(menuID, playerInventory, this.slot);
        }
    }
}

