/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.container.ContainerPreciseExportBus;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;

public class PartPreciseExportBus
extends ExportBusPart {
    public static List<ResourceLocation> MODELS = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"extendedae", (String)"part/precise_export_bus_base"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_on"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_off"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.getFirst(), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.getFirst(), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.getFirst(), MODELS.get(3)});
    private ConfigInventory config;
    private Object2LongMap<AEKey> amountMap;

    public PartPreciseExportBus(IPartItem<?> partItem) {
        super(partItem);
    }

    public void readFromNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.readFromNBT(extra, registries);
        this.config.readFromChildTag(extra, "config2", registries);
        this.rebuildAmountMap();
    }

    private void rebuildAmountMap() {
        this.amountMap = new Object2LongOpenHashMap();
        for (int x = 0; x < this.config.size(); ++x) {
            GenericStack stack = this.config.getStack(x);
            if (stack == null || stack.amount() <= 0L) continue;
            this.amountMap.put((Object)stack.what(), stack.amount());
        }
    }

    public void writeToNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.writeToNBT(extra, registries);
        this.config.writeToChildTag(extra, "config2", registries);
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = ConfigInventory.configStacks((int)63).supportedTypes((Collection)StackWorldBehaviors.withExportStrategy()).changeListener(this::onConfigChange).allowOverstacking(true).build();
        }
        return this.config;
    }

    private void onConfigChange() {
        Ae2Reflect.updatePartState((IOBusPart)this);
        this.amountMap = null;
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
    }

    private void attemptCrafting(StackTransferContext context, ICraftingService cg, int slotToExport, AEKey what, long targetAmount) {
        long amount = this.getExportStrategy().push(what, targetAmount, Actionable.SIMULATE);
        if (amount == targetAmount) {
            this.requestCrafting(cg, slotToExport, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)what.getAmountPerOperation()));
        }
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        long added;
        long amt;
        if (this.amountMap == null) {
            this.rebuildAmountMap();
        }
        if ((amt = this.amountMap.getLong((Object)what)) > 0L && amount >= amt && (added = this.getExportStrategy().push(what, amt, Actionable.SIMULATE)) == amt) {
            return super.insertCraftedItems(link, what, amt, mode);
        }
        return 0L;
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = Ae2Reflect.getExportContext(this, storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            long realSend;
            long canExt;
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null) continue;
            AEKey what = stack.what();
            long amount = stack.amount();
            int transferFactor = what.getAmountPerOperation();
            if (this.craftOnly()) {
                this.attemptCrafting(context, cg, slotToExport, what, amount);
                continue;
            }
            int before = context.getOperationsRemaining();
            if ((long)before < Math.max(1L, amount / (long)transferFactor)) break;
            long toSend = this.getExportStrategy().push(what, amount, Actionable.SIMULATE);
            if (toSend == amount && (canExt = PartPreciseExportBus.simulateExtract(context, what, amount)) == amount && (realSend = this.getExportStrategy().transfer(context, what, amount)) > 0L) {
                context.reduceOperationsRemaining(Math.max(1L, amount / (long)transferFactor));
            }
            if (before != context.getOperationsRemaining() || !this.isCraftingEnabled()) continue;
            this.attemptCrafting(context, cg, slotToExport, what, amount);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    protected int getOperationsPerTick() {
        return 64;
    }

    protected MenuType<?> getMenuType() {
        return ContainerPreciseExportBus.TYPE;
    }

    private static long simulateExtract(StackTransferContext context, AEKey what, long amount) {
        IStorageService inv = context.getInternalStorage();
        return StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
    }
}

