/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.SlotSemantic;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.SetStockAmountMenu;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigMenuInventory;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.client.ExSemantics;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class ContainerExInterface
extends UpgradeableMenu<InterfaceLogicHost>
implements IPage {
    public static final String ACTION_OPEN_SET_AMOUNT = "setAmount";
    public static final MenuType<ContainerExInterface> TYPE = MenuTypeBuilder.create(ContainerExInterface::new, InterfaceLogicHost.class).buildUnregistered(ExtendedAE.id("ex_interface"));
    public static final MenuType<ContainerExInterface> TYPE_OVERSIZE = MenuTypeBuilder.create(ContainerExInterface::new, InterfaceLogicHost.class).buildUnregistered(ExtendedAE.id("oversize_interface"));
    private static final int PAGE = 18;
    private static final int LINE = 9;
    private static final SlotSemantic[] CONFIG_PATTERN = new SlotSemantic[]{ExSemantics.EX_1, ExSemantics.EX_3, ExSemantics.EX_5, ExSemantics.EX_7};
    private static final SlotSemantic[] STORAGE_PATTERN = new SlotSemantic[]{ExSemantics.EX_2, ExSemantics.EX_4, ExSemantics.EX_6, ExSemantics.EX_8};
    private final List<Slot> configSlots = new ArrayList<Slot>();
    @GuiSync(value=7)
    public int page;

    public ContainerExInterface(MenuType<?> menuType, int id, Inventory ip, InterfaceLogicHost host) {
        super(menuType, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(ACTION_OPEN_SET_AMOUNT, Integer.class, this::openSetAmountMenu);
        InterfaceLogic logic = host.getInterfaceLogic();
        ConfigMenuInventory config = logic.getConfig().createMenuWrapper();
        for (int x = 0; x < config.size(); ++x) {
            int page = x / 18;
            int row = (x - page * 18) / 9;
            this.configSlots.add(this.addSlot((Slot)new FakeSlot((InternalInventory)config, x), CONFIG_PATTERN[2 * page + row]));
        }
        ConfigMenuInventory storage = logic.getStorage().createMenuWrapper();
        for (int x = 0; x < storage.size(); ++x) {
            int page = x / 18;
            int row = (x - page * 18) / 9;
            this.addSlot((Slot)new AppEngSlot((InternalInventory)storage, x), STORAGE_PATTERN[2 * page + row]);
        }
    }

    public List<Slot> getConfigSlots() {
        return this.configSlots;
    }

    public void showPage(int page) {
        for (int index = 0; index < 4; ++index) {
            List slots = this.getSlots(CONFIG_PATTERN[index]);
            slots.addAll(this.getSlots(STORAGE_PATTERN[index]));
            for (Slot slot : slots) {
                if (!(slot instanceof AppEngSlot)) continue;
                AppEngSlot as = (AppEngSlot)slot;
                as.setActive(page == index / 2);
            }
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
    }

    public void openSetAmountMenu(int configSlot) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_OPEN_SET_AMOUNT, configSlot);
        } else {
            GenericStack stack = ((InterfaceLogicHost)this.getHost()).getConfig().getStack(configSlot);
            if (stack != null) {
                SetStockAmountMenu.open((ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuHostLocator)this.getLocator(), (int)configSlot, (AEKey)stack.what(), (int)((int)stack.amount()));
            }
        }
    }

    public void broadcastChanges() {
        IUpgradeableObject iUpgradeableObject = this.getHost();
        if (iUpgradeableObject instanceof IPage) {
            IPage pg = (IPage)iUpgradeableObject;
            this.page = pg.getPage();
        }
        super.broadcastChanges();
    }

    @Override
    public void setPage(int page) {
        this.page = page;
        IUpgradeableObject iUpgradeableObject = this.getHost();
        if (iUpgradeableObject instanceof IPage) {
            IPage pg = (IPage)iUpgradeableObject;
            pg.setPage(page);
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

