/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.advancedimporter;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.neoforge.support.render.ModelProperties;
import edivad.extrastorage.advancedimporter.AdvancedImporterContainerMenu;
import edivad.extrastorage.setup.ESBlockEntities;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedImporterBlockEntity
extends AbstractCableLikeBlockEntity<ImporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvancedImporterBlockEntity.class);
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filter = FilterWithFuzzyMode.createAndListenForUniqueFilters((ResourceContainer)ResourceContainerImpl.createForFilter((int)18), () -> ((AdvancedImporterBlockEntity)this).setChanged(), this::setFilters);
    private final UpgradeContainer upgradeContainer;

    public AdvancedImporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ESBlockEntities.ADVANCED_IMPORTER.get(), pos, state, (AbstractNetworkNode)new ImporterNetworkNode(Platform.INSTANCE.getConfig().getImporter().getEnergyUsage()));
        ((ImporterNetworkNode)this.mainNetworkNode).setNormalizer(this.filter.createNormalizer());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.IMPORTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getImporter().getEnergyUsage();
            ((ImporterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.initialize(serverLevel);
            }
        });
        this.ticker = this.upgradeContainer.getTicker();
    }

    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ImporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized importer at {} with strategy {}", (Object)this.worldPosition, (Object)strategy);
        ((ImporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ImporterTransferStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        List factories = RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll();
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)this.upgradeContainer)).toList());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode((FilterMode)((ImporterNetworkNode)this.mainNetworkNode).getFilterMode()));
        this.filter.save(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_FILTER_MODE)) {
            ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.getInt(TAG_FILTER_MODE)));
        }
        this.filter.load(tag, provider);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    public boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    public FilterMode getFilterMode() {
        return ((ImporterNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    public void setFilterMode(FilterMode mode) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.IMPORTER);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new AdvancedImporterContainerMenu(windowId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, p -> Container.stillValidBlockEntity((BlockEntity)this, (Player)p));
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.CABLE_CONNECTIONS, (Object)this.connections).build();
    }
}

