/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.device.FluxDeviceType;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.util.FluxUtils;

public class PhantomFluxDevice
implements IFluxDevice {
    private int mNetworkID;
    private String mCustomName;
    private int mPriority;
    private long mLimit;
    private UUID mOwnerUUID;
    private FluxDeviceType mDeviceType;
    private GlobalPos mGlobalPos;
    private boolean mSurgeMode;
    private boolean mDisableLimit;
    private boolean mChunkLoaded;
    private boolean mForcedLoading;
    private long mBuffer;
    private long mChange;
    private ItemStack mDisplayStack;

    @Nonnull
    public static PhantomFluxDevice makeUnloaded(@Nonnull TileFluxDevice device) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.mNetworkID = device.getNetworkID();
        t.mCustomName = device.getCustomName();
        t.mPriority = device.getRawPriority();
        t.mLimit = device.getRawLimit();
        t.mOwnerUUID = device.getOwnerUUID();
        t.mDeviceType = device.getDeviceType();
        t.mGlobalPos = device.getGlobalPos();
        t.mSurgeMode = device.getSurgeMode();
        t.mDisableLimit = device.getDisableLimit();
        t.mBuffer = device.getTransferBuffer();
        t.mDisplayStack = device.getDisplayStack();
        return t;
    }

    @Nonnull
    public static PhantomFluxDevice makeUpdated(@Nonnull GlobalPos pos, @Nonnull CompoundTag tag) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.mGlobalPos = pos;
        t.readCustomTag(tag, (byte)20);
        return t;
    }

    @Nonnull
    public static PhantomFluxDevice make(@Nonnull CompoundTag tag) {
        PhantomFluxDevice t = new PhantomFluxDevice();
        t.readCustomTag(tag, (byte)1);
        return t;
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 1 || type == 20) {
            FluxUtils.writeGlobalPos(tag, this.mGlobalPos);
            tag.putByte("device_type", this.mDeviceType.getId());
            tag.putInt("network_id", this.mNetworkID);
            tag.putString("custom_name", this.mCustomName);
            tag.putInt("priority", this.mPriority);
            tag.putLong("limit", this.mLimit);
            tag.putBoolean("surge_mode", this.mSurgeMode);
            tag.putBoolean("disable_limit", this.mDisableLimit);
            tag.putUUID("player_uuid", this.mOwnerUUID);
            tag.putLong("energy", this.mBuffer);
            tag.putString("device_item", this.mDisplayStack.getItemHolder().getRegisteredName());
        }
    }

    @Override
    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 1) {
            this.mGlobalPos = FluxUtils.readGlobalPos(tag);
        }
        if (type == 1 || type == 20) {
            this.mDeviceType = FluxDeviceType.fromId(tag.getByte("device_type"));
            this.mNetworkID = tag.getInt("network_id");
            this.mCustomName = tag.getString("custom_name");
            this.mPriority = tag.getInt("priority");
            this.mLimit = tag.getLong("limit");
            this.mSurgeMode = tag.getBoolean("surge_mode");
            this.mDisableLimit = tag.getBoolean("disable_limit");
            this.mOwnerUUID = tag.getUUID("player_uuid");
            this.mBuffer = tag.getLong("energy");
            this.mDisplayStack = PhantomFluxDevice.createDisplayItemStack(tag);
        }
        if (type == 20) {
            this.mForcedLoading = tag.getBoolean("forced_loading");
            this.mChunkLoaded = tag.getBoolean("chunk_loaded");
            this.mChange = tag.getLong("change");
        }
    }

    private static ItemStack createDisplayItemStack(CompoundTag tag) {
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("device_item")))).getDefaultInstance();
        stack.set(FluxDataComponents.FLUX_CONFIG, (Object)FluxDeviceConfigComponent.EMPTY.withNetwork(tag.getInt("network_id")));
        stack.set(FluxDataComponents.STORED_ENERGY, (Object)tag.getLong("energy"));
        return stack;
    }

    @Override
    public int getNetworkID() {
        return this.mNetworkID;
    }

    @Override
    public void onPlayerOpened(@Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onPlayerClosed(@Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public int getRawPriority() {
        return this.mPriority;
    }

    @Override
    @Nonnull
    public UUID getOwnerUUID() {
        return this.mOwnerUUID;
    }

    @Override
    @Nonnull
    public FluxDeviceType getDeviceType() {
        return this.mDeviceType;
    }

    @Override
    public boolean isChunkLoaded() {
        return this.mChunkLoaded;
    }

    @Override
    public boolean isForcedLoading() {
        return this.mForcedLoading;
    }

    @Override
    public long getRawLimit() {
        return this.mLimit;
    }

    @Override
    public long getMaxTransferLimit() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    @Nonnull
    public GlobalPos getGlobalPos() {
        return this.mGlobalPos;
    }

    @Override
    @Nonnull
    public String getCustomName() {
        return this.mCustomName;
    }

    @Override
    public boolean getDisableLimit() {
        return this.mDisableLimit;
    }

    @Override
    public boolean getSurgeMode() {
        return this.mSurgeMode;
    }

    @Override
    @Nonnull
    public ItemStack getDisplayStack() {
        return this.mDisplayStack;
    }

    @Override
    public long getTransferBuffer() {
        return this.mBuffer;
    }

    @Override
    public long getTransferChange() {
        return this.mChange;
    }

    @Nullable
    public FluxMenu createMenu(int containerId, @Nonnull Inventory inventory, @Nonnull Player player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }
}

