/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxNetworks;

public class Channel {
    static final String PROTOCOL = "800";
    static final Channel sChannel = new Channel();
    public static final StreamCodec<FriendlyByteBuf, FriendlyByteBuf> BYTE_BUFFER_CODEC = new StreamCodec<FriendlyByteBuf, FriendlyByteBuf>(){

        @Nonnull
        public FriendlyByteBuf decode(@Nonnull FriendlyByteBuf source) {
            return new FriendlyByteBuf(source.readRetainedSlice(source.readableBytes()));
        }

        public void encode(@Nonnull FriendlyByteBuf target, @Nonnull FriendlyByteBuf source) {
            target.writeBytes(source.slice());
        }
    };
    private MessageHandler mS2CMessageHandler;
    private MessageHandler mC2SMessageHandler;

    @Nonnull
    static FriendlyByteBuf buffer(int index) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(index);
        return new FriendlyByteBuf(buf);
    }

    public static Channel get() {
        return sChannel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(@Nonnull FriendlyByteBuf payload) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            connection.send((CustomPacketPayload)new Message(payload));
        } else {
            payload.release();
        }
    }

    public final void sendToPlayer(@Nonnull FriendlyByteBuf payload, @Nonnull Player player) {
        this.sendToPlayer(payload, (ServerPlayer)player);
    }

    public void sendToPlayer(@Nonnull FriendlyByteBuf payload, @Nonnull ServerPlayer player) {
        player.connection.send((CustomPacketPayload)new Message(payload));
    }

    public void sendToAll(@Nonnull FriendlyByteBuf payload) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new Message(payload));
        ServerLifecycleHooks.getCurrentServer().getPlayerList().broadcastAll((Packet)packet);
    }

    public void sendToTrackingChunk(@Nonnull FriendlyByteBuf payload, @Nonnull LevelChunk chunk) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new Message(payload));
        ((ServerLevel)chunk.getLevel()).getChunkSource().chunkMap.getPlayers(chunk.getPos(), false).forEach(p -> p.connection.send((Packet)packet));
    }

    public void setS2CMessageHandler(@Nonnull MessageHandler s2cMessageHandler) {
        this.mS2CMessageHandler = s2cMessageHandler;
    }

    public void setC2SMessageHandler(@Nonnull MessageHandler c2sMessageHandler) {
        this.mC2SMessageHandler = c2sMessageHandler;
    }

    public record Message(FriendlyByteBuf data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(FluxNetworks.location("message"));
        public static final StreamCodec<FriendlyByteBuf, Message> CODEC = StreamCodec.composite(BYTE_BUFFER_CODEC, Message::data, Message::new);

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void handle(@Nonnull IPayloadContext context) {
            int index = this.data.readUnsignedShort();
            if (context.flow() == PacketFlow.CLIENTBOUND) {
                Channel.get().mS2CMessageHandler.handle(index, this.data, context);
            } else {
                Channel.get().mC2SMessageHandler.handle(index, this.data, context);
            }
        }
    }

    @FunctionalInterface
    public static interface MessageHandler {
        public void handle(int var1, @Nonnull FriendlyByteBuf var2, @Nonnull IPayloadContext var3);
    }
}

