/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.compat.create;

import com.simibubi.create.api.schematic.requirement.SchematicRequirementRegistries;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.util.Utils;

public class FramedBlockEntityItemRequirement
implements SchematicRequirementRegistries.BlockEntityRequirement {
    public static final FramedBlockEntityItemRequirement INSTANCE = new FramedBlockEntityItemRequirement();

    protected FramedBlockEntityItemRequirement() {
    }

    public final ItemRequirement getRequiredItems(BlockEntity blockEntity, BlockState state) {
        if (blockEntity instanceof FramedBlockEntity) {
            IFramedDoubleBlockEntity fdbe;
            CamoContainer<?, ?> camoTwo;
            FramedBlockEntity fbe = (FramedBlockEntity)blockEntity;
            ArrayList<ItemRequirement.StackRequirement> requirements = new ArrayList<ItemRequirement.StackRequirement>();
            CamoContainer<?, ?> camoOne = fbe.getCamo();
            if (!camoOne.isEmpty() && camoOne.canTriviallyConvertToItemStack()) {
                requirements.add(FramedBlockEntityItemRequirement.consume(CamoContainerHelper.dropCamo(camoOne)));
            }
            if (fbe instanceof IFramedDoubleBlockEntity && !(camoTwo = (fdbe = (IFramedDoubleBlockEntity)((Object)fbe)).getCamoTwo()).isEmpty() && camoTwo.canTriviallyConvertToItemStack()) {
                requirements.add(FramedBlockEntityItemRequirement.consume(CamoContainerHelper.dropCamo(camoTwo)));
            }
            if (fbe.isGlowing()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)Items.GLOWSTONE_DUST));
            }
            if (fbe.isMarkedIntangible()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)Utils.PHANTOM_PASTE.value()));
            }
            if (fbe.isReinforced()) {
                requirements.add(FramedBlockEntityItemRequirement.consume((ItemLike)Utils.FRAMED_REINFORCEMENT.value()));
            }
            this.collectAdditionalRequirements(fbe, requirements);
            return new ItemRequirement(requirements);
        }
        return ItemRequirement.NONE;
    }

    protected void collectAdditionalRequirements(FramedBlockEntity blockEntity, List<ItemRequirement.StackRequirement> requirements) {
    }

    protected static ItemRequirement.StackRequirement consume(ItemLike item) {
        return FramedBlockEntityItemRequirement.consume(new ItemStack(item));
    }

    protected static ItemRequirement.StackRequirement consume(ItemStack stack) {
        return new ItemRequirement.StackRequirement(stack, ItemRequirement.ItemUseType.CONSUME);
    }

    protected static ItemRequirement.StackRequirement consumeStrict(ItemStack stack) {
        return new ItemRequirement.StrictNbtStackRequirement(stack, ItemRequirement.ItemUseType.CONSUME);
    }
}

