/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.datagen.loot;

import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import xfacthd.framedblocks.api.datagen.loot.objects.NonTrivialCamoLootCondition;
import xfacthd.framedblocks.api.datagen.loot.objects.SplitCamoLootFunction;
import xfacthd.framedblocks.common.FBContent;

public abstract class FramedBlockLootSubProvider
extends BlockLootSubProvider {
    protected FramedBlockLootSubProvider(HolderLookup.Provider lookupProvider) {
        super(Set.of(), FeatureFlags.VANILLA_SET, lookupProvider);
    }

    protected void dropSelfWithCamo(Block block) {
        this.dropWithCamo(block, block);
    }

    protected void dropSelfWithCamo(Block block, Consumer<LootPoolSingletonContainer.Builder<?>> itemModifier) {
        this.dropWithCamo(block, block, itemModifier);
    }

    protected void dropOtherWithCamo(Block block, Block drop) {
        this.dropWithCamo(block, drop);
    }

    protected void dropMultipleWithCamo(Block block, Block drop, int count) {
        this.add(block, funcBlock -> {
            LootTable.Builder table = LootTable.lootTable();
            int i = 0;
            while (i < count) {
                int index = i++;
                table.withPool(this.createDropWithCamoPool(block, drop, builder -> builder.apply((LootItemFunction.Builder)SplitCamoLootFunction.split(index).when(NonTrivialCamoLootCondition.BUILDER))));
            }
            return table;
        });
    }

    protected final void dropDoorWithCamo(Block block) {
        this.dropWithCamo(block, block, builder -> builder.when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))));
    }

    protected final void dropWithCamo(Block block, Block drop) {
        this.dropWithCamo(block, drop, builder -> {});
    }

    protected final void dropWithCamo(Block block, Block drop, Consumer<LootPoolSingletonContainer.Builder<?>> itemModifier) {
        this.add(block, funcBlock -> LootTable.lootTable().withPool(this.createDropWithCamoPool((Block)funcBlock, drop, itemModifier)));
    }

    protected final LootPool.Builder createDropWithCamoPool(Block block) {
        return this.createDropWithCamoPool(block, block, builder -> {});
    }

    protected final LootPool.Builder createDropWithCamoPool(Block block, Block drop, Consumer<LootPoolSingletonContainer.Builder<?>> itemModifier) {
        LootPoolSingletonContainer.Builder tableItem = LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)FBContent.DC_TYPE_CAMO_LIST.value()).when(NonTrivialCamoLootCondition.BUILDER));
        itemModifier.accept(tableItem);
        return (LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)tableItem)));
    }
}

