/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slope.FramedPyramidGeometry;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public class FramedElevatedPyramidSlabGeometry
extends FramedPyramidGeometry {
    public FramedElevatedPyramidSlabGeometry(GeometryFactory.Context ctx) {
        super(ctx);
    }

    @Override
    protected void buildBody(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        if (Utils.isY(this.facing)) {
            boolean up;
            boolean bl = up = this.facing == Direction.UP;
            if (!this.ySlope && quadDir.getAxis() != this.facing.getAxis()) {
                QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(!up, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.cutSideLeftRight(false, up ? 0.5f : 1.5f, up ? 1.5f : 0.5f)).apply(Modifiers.cutSideLeftRight(true, up ? 0.5f : 1.5f, up ? 1.5f : 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).apply(Modifiers.offset(quadDir, 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.facing) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    float angle;
                    boolean northeast = dir == Direction.NORTH || dir == Direction.EAST;
                    float f = angle = up ? -45.0f : 45.0f;
                    if (northeast) {
                        angle *= -1.0f;
                    }
                    QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(dir, this.slopeHeight), this.hasPillar).apply(Modifiers.cutTopBottom(dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(dir.getCounterClockWise(), 0.5f, 1.5f)).apply(Modifiers.cutTopBottom(dir.getClockWise(), 1.5f, 0.5f)).apply(Modifiers.rotateCentered(dir.getClockWise().getAxis(), angle, true)).apply(Modifiers.offset(this.facing.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
            }
            if (quadDir.getAxis() != this.facing.getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).export(quadMap.get(quadDir));
            }
        } else {
            if (!this.ySlope && quadDir.getAxis() == this.facing.getAxis()) {
                QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(true, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 1.5f, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 1.5f, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(false, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.5f, 1.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.5f, 1.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && Utils.isY(quadDir)) {
                float angle;
                boolean up = quadDir == Direction.UP;
                float f = angle = up ? 45.0f : -45.0f;
                if (this.facing == Direction.NORTH || this.facing == Direction.EAST) {
                    angle *= -1.0f;
                }
                Vector3f origin = this.facing.getOpposite().step().max((Vector3fc)ZERO);
                if (up) {
                    origin.add(0.0f, 1.0f, 0.0f);
                }
                QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(this.facing, this.slopeHeight), this.hasPillar).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.5f, 1.5f)).apply(Modifiers.cutTopBottom(this.facing.getClockWise(), 1.5f, 0.5f)).apply(Modifiers.rotate(this.facing.getClockWise().getAxis(), origin, angle, true)).apply(Modifiers.offset(quadDir, 0.5f)).export(quadMap.get(null));
            } else if (quadDir.getAxis() == this.facing.getClockWise().getAxis()) {
                boolean right = quadDir == this.facing.getClockWise();
                QuadModifier.of(quad).applyIf(Modifiers.cutSideLeftRight(this.facing, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.5f)).apply(Modifiers.cutSideUpDown(true, right ? 1.5f : 0.5f, right ? 0.5f : 1.5f)).apply(Modifiers.cutSideUpDown(false, right ? 1.5f : 0.5f, right ? 0.5f : 1.5f)).apply(Modifiers.makeHorizontalSlope(!right, 45.0f)).apply(Modifiers.offset(quadDir, 0.5f)).export(quadMap.get(null));
            }
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir.getAxis() != this.facing.getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).export(quadMap.get(quadDir));
            }
        }
    }

    @Override
    protected float computeSlopeHeight(PillarConnection pillar) {
        return switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 1.0f;
            case PillarConnection.POST -> 0.875f;
            case PillarConnection.PILLAR -> 0.75f;
        };
    }

    @Override
    protected float computePillarHeight(PillarConnection pillar) {
        return switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 0.0f;
            case PillarConnection.POST -> 0.125f;
            case PillarConnection.PILLAR -> 0.25f;
        };
    }
}

