/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatSlopePanelCornerGeometry
extends Geometry {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final HorizontalRotation rotRotation;
    private final Direction orientation;
    private final Direction rotOrientation;
    private final boolean front;
    private final boolean ySlope;

    public FramedFlatSlopePanelCornerGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.rotRotation = this.rotation.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.orientation = this.rotation.withFacing(this.facing);
        this.rotOrientation = this.rotRotation.withFacing(this.facing);
        this.front = (Boolean)ctx.state().getValue((Property)PropertyHolder.FRONT);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        if (face == this.orientation.getOpposite()) {
            FramedFlatSlopePanelCornerGeometry.createSideTriangle(quadMap, quad, this.facing, this.rotRotation, this.front, false);
        } else if (face == this.rotOrientation.getOpposite()) {
            FramedFlatSlopePanelCornerGeometry.createSideTriangle(quadMap, quad, this.facing, this.rotation, this.front, false);
        } else if (face == this.facing.getOpposite()) {
            if (!this.ySlope || !Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
            }
            if (!this.ySlope || !Utils.isY(this.rotOrientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.rotOrientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
            }
        } else if (this.ySlope && Utils.isY(this.orientation) && face == this.orientation) {
            QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createVerticalSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing.getOpposite(), 0.5f), this.front).export(quadMap.get(null));
        } else if (this.ySlope && Utils.isY(this.rotOrientation) && face == this.rotOrientation) {
            QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createVerticalSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.rotOrientation)).applyIf(Modifiers.offset(this.facing.getOpposite(), 0.5f), this.front).export(quadMap.get(null));
        } else if (face == this.facing && this.front) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    public static QuadModifier.Modifier createSlopeTriangle(Direction facing, Direction orientation, boolean second) {
        if (Utils.isY(orientation)) {
            boolean down = orientation == Direction.UP;
            float right = down != second ? 0.0f : 1.0f;
            float left = down != second ? 1.0f : 0.0f;
            return Modifiers.cutSideUpDown(down, right, left);
        }
        boolean right = orientation == facing.getClockWise();
        float top = right != second ? 0.0f : 1.0f;
        float bot = right != second ? 1.0f : 0.0f;
        return Modifiers.cutSideLeftRight(right, top, bot);
    }

    public static QuadModifier.Modifier createVerticalSlopeTriangle(Direction facing, Direction orientation, boolean second) {
        boolean down = orientation == Direction.DOWN;
        float right = second == down ? 0.0f : 1.0f;
        float left = second == down ? 1.0f : 0.0f;
        return Modifiers.cutTopBottom(facing.getOpposite(), right, left);
    }

    public static void createSideTriangle(QuadMap quadMap, BakedQuad quad, Direction facing, HorizontalRotation rotation, boolean front, boolean extended) {
        Direction face = quad.getDirection();
        Direction orientation = rotation.withFacing(facing);
        boolean yAxis = Utils.isY(orientation);
        if (yAxis) {
            float top;
            boolean up;
            boolean bl = up = orientation == Direction.UP;
            float f = up ? (front ? 0.5f : 0.0f) : (top = front ? 1.0f : 0.5f);
            float bottom = up ? (front ? 1.0f : 0.5f) : (front ? 0.5f : 0.0f);
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(facing.getOpposite(), top, bottom)).applyIf(Modifiers.cutSideLeftRight(facing, 0.5f), front && !extended).export(quadMap.get(face));
        } else {
            float right;
            boolean rightRot;
            boolean bl = rightRot = rotation == HorizontalRotation.RIGHT;
            float f = rightRot ? (front ? 1.0f : 0.5f) : (right = front ? 0.5f : 0.0f);
            float left = rightRot ? (front ? 0.5f : 0.0f) : (front ? 1.0f : 0.5f);
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(facing.getOpposite(), right, left)).applyIf(Modifiers.cutTopBottom(facing, 0.5f), front && !extended).export(quadMap.get(face));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

