/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanelcorner;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedLargeCornerSlopePanelWallGeometry
extends Geometry {
    private final Direction dir;
    private final Direction horRotDir;
    private final Direction vertRotDir;
    private final boolean ySlope;

    public FramedLargeCornerSlopePanelWallGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(this.dir);
        Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(this.dir);
        this.horRotDir = Utils.isY(rotDir) ? perpRotDir : rotDir;
        this.vertRotDir = Utils.isY(rotDir) ? rotDir : perpRotDir;
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean up;
        Direction quadDir = quad.getDirection();
        boolean cw = this.horRotDir == this.dir.getClockWise();
        boolean bl = up = this.vertRotDir == Direction.UP;
        if (quadDir == this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.horRotDir, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.horRotDir.getOpposite(), 0.5f)).apply(Modifiers.cutSideUpDown(!up, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.horRotDir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).apply(Modifiers.cutSideUpDown(up, cw ? 0.5f : 1.0f, cw ? 1.0f : 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.vertRotDir) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.horRotDir, 0.5f)).apply(Modifiers.cutTopBottom(this.horRotDir.getOpposite(), cw ? 1.0f : 0.5f, cw ? 0.5f : 1.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.horRotDir.getOpposite(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.horRotDir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.vertRotDir == Direction.UP, cw ? 1.0f : 0.5f, cw ? 0.5f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!cw, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
        } else if (!this.ySlope && quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.horRotDir.getOpposite(), up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.makeVerticalSlope(!up, FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).apply(Modifiers.offset(this.vertRotDir.getOpposite(), 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && quadDir == this.vertRotDir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.horRotDir.getOpposite(), cw ? 1.0f : 0.5f, cw ? 0.5f : 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
        }
    }
}

