/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.debug.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.block.BlockCamoContent;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.config.DevToolsConfig;

public class DoubleBlockPartDebugRenderer
implements BlockDebugRenderer<FramedDoubleBlockEntity> {
    public static final DoubleBlockPartDebugRenderer INSTANCE = new DoubleBlockPartDebugRenderer();
    private static final FramedBlockData MODEL_DATA = new FramedBlockData(new BlockCamoContent(Blocks.STONE.defaultBlockState()), false);

    private DoubleBlockPartDebugRenderer() {
    }

    @Override
    public void render(FramedDoubleBlockEntity be, BlockHitResult blockHit, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        if (!(state.getBlock() instanceof IFramedBlock)) {
            return;
        }
        Tuple<BlockState, BlockState> blockPair = be.getBlockPair();
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        boolean secondary = be.debugHitSecondary(blockHit, player);
        BlockState partState = secondary ? (BlockState)blockPair.getB() : (BlockState)blockPair.getA();
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(partState);
        OutlineBufferSource outlineBuffer = Minecraft.getInstance().renderBuffers().outlineBufferSource();
        outlineBuffer.setColor(secondary ? 0 : 255, secondary ? 255 : 0, 0, 255);
        ModelData modelData = ((IFramedBlock)state.getBlock()).unpackNestedModelData(be.getModelData(), state, partState);
        modelData = modelData.derive().with(FramedBlockData.PROPERTY, (Object)MODEL_DATA).build();
        VertexConsumer consumer = outlineBuffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), consumer, partState, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, RenderType.solid());
    }

    @Override
    public boolean isEnabled() {
        return DevToolsConfig.VIEW.isDoubleBlockPartHitDebugRendererEnabled();
    }
}

