/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.prism.IFramedPrismBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedPrismBlock
extends FramedBlock
implements IFramedPrismBlock {
    public FramedPrismBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.FACING_AXIS, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedPrismBlock.getStateForPlacement(context, this);
    }

    public static BlockState getStateForPlacement(BlockPlaceContext ctx, Block block) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, ctx).withCustom((state, modCtx) -> {
            Direction face = modCtx.getClickedFace();
            Direction.Axis axis = modCtx.getHorizontalDirection().getAxis();
            if (!Utils.isY(face)) {
                Vec3 subHit = Utils.fraction(modCtx.getClickLocation());
                double xz = (Utils.isX(face) ? subHit.z() : subHit.x()) - 0.5;
                double y = subHit.y() - 0.5;
                axis = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? face.getClockWise().getAxis() : Direction.Axis.Y;
            }
            return (BlockState)state.setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.of(face, axis)));
        })).withYSlope(Utils.isY(ctx.getClickedFace()))).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        return (BlockState)state.setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.rotate(rot)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        return (BlockState)state.setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.mirror(mirror)));
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.UP_X));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isInnerPrism() {
        return this.getBlockType() != BlockType.FRAMED_PRISM;
    }
}

