/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.capability;

import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

public final class StorageBlockItemStackHandler
extends ItemStackHandler
implements IStorageBlockItemHandler {
    @Nullable
    private final FramedStorageBlockEntity be;

    public StorageBlockItemStackHandler(@Nullable FramedStorageBlockEntity be, int slots) {
        super(slots);
        this.be = be;
    }

    protected void onContentsChanged(int slot) {
        if (this.be != null) {
            this.be.setChanged();
        }
    }

    @Override
    public FramedStorageMenu createMenu(int windowId, Inventory inv) {
        return FramedStorageMenu.createSingle(windowId, inv, this);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.be != null && this.be.isUsableByPlayer(player);
    }

    @Override
    public void open() {
        FramedStorageBlockEntity framedStorageBlockEntity = this.be;
        if (framedStorageBlockEntity instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity chest = (FramedChestBlockEntity)framedStorageBlockEntity;
            chest.doOpen();
        }
    }

    @Override
    public void close() {
        FramedStorageBlockEntity framedStorageBlockEntity = this.be;
        if (framedStorageBlockEntity instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity chest = (FramedChestBlockEntity)framedStorageBlockEntity;
            chest.close();
        }
    }

    public List<ItemStack> getBackingList() {
        return this.stacks;
    }
}

