/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeRayTraceCallback;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedOwnableBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

final class FramedOneWayWindowRayTraceCallback
implements JadeRayTraceCallback {
    private final IWailaClientRegistration registration;

    public FramedOneWayWindowRayTraceCallback(IWailaClientRegistration registration) {
        this.registration = registration;
    }

    @Nullable
    public Accessor<?> onRayTrace(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        BlockAccessor blockAccessor;
        if (accessor instanceof BlockAccessor && (blockAccessor = (BlockAccessor)accessor).getBlockState().is(FBContent.BLOCK_FRAMED_ONE_WAY_WINDOW)) {
            Direction face = ((NullableDirection)((Object)blockAccessor.getBlockState().getValue(PropertyHolder.NULLABLE_FACE))).toDirection();
            if (face == null || face == blockAccessor.getSide()) {
                return accessor;
            }
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (!(blockEntity instanceof FramedOwnableBlockEntity)) {
                return accessor;
            }
            FramedOwnableBlockEntity be = (FramedOwnableBlockEntity)blockEntity;
            if (be.getCamo().isEmpty() || be.getOwner() != null && be.getOwner().equals(accessor.getPlayer().getUUID())) {
                return accessor;
            }
            BlockState camoState = ((CamoContent)be.getCamo().getContent()).getAsBlockState();
            if (!camoState.isAir()) {
                return this.registration.blockAccessor().from(blockAccessor).blockEntity(() -> null).blockState(camoState).build();
            }
        }
        return accessor;
    }
}

