/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.interactive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class ItemFrameShapes {
    private static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        map.put(new ShapeKey(Direction.UP, false), Block.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        map.put(new ShapeKey(Direction.UP, true), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        map.put(new ShapeKey(Direction.DOWN, false), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0));
        map.put(new ShapeKey(Direction.DOWN, true), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        VoxelShape northShape = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);
        VoxelShape northMapShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        ShapeUtils.makeHorizontalRotationsWithFlag(northShape, northMapShape, Direction.NORTH, map, ShapeKey::new);
    });

    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            boolean map = (Boolean)state.getValue((Property)PropertyHolder.MAP_FRAME);
            builder.put((Object)state, (Object)SHAPES.get(new ShapeKey(dir, map)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private ItemFrameShapes() {
    }

    private record ShapeKey(Direction dir, boolean map) {
    }
}

