/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class SlopeSlabShapes
implements SplitShapeGenerator {
    public static final ShapeCache<SlopeSlabShape> SHAPES = SlopeSlabShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0)));
    public static final ShapeCache<SlopeSlabShape> OCCLUSION_SHAPES = SlopeSlabShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.75, (double)8.0), Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)0.5)));

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopeSlabShapes.generate(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopeSlabShapes.generate(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeSlabShape> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottomBottomHalf = cache.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
        VoxelShape shapeBottomTopHalf = cache.get(SlopeSlabShape.BOTTOM_TOP_HALF);
        VoxelShape shapeTopBottomHalf = cache.get(SlopeSlabShape.TOP_BOTTOM_HALF);
        VoxelShape shapeTopTopHalf = cache.get(SlopeSlabShape.TOP_TOP_HALF);
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeBottomBottomHalf, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeBottomTopHalf, Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(shapeTopBottomHalf, Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(shapeTopTopHalf, Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.getValue((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.getValue((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.get2DDataValue() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<SlopeSlabShape> makeCache(Supplier<VoxelShape> bottomShapeFactory) {
        return ShapeCache.createEnum(SlopeSlabShape.class, map -> {
            VoxelShape shapeBottom = (VoxelShape)bottomShapeFactory.get();
            map.put(SlopeSlabShape.BOTTOM_BOTTOM_HALF, shapeBottom);
            map.put(SlopeSlabShape.BOTTOM_TOP_HALF, shapeBottom.move(0.0, 0.5, 0.0));
            VoxelShape shapeTop = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.DOWN, shapeBottom);
            map.put(SlopeSlabShape.TOP_BOTTOM_HALF, shapeTop.move(0.0, -0.5, 0.0));
            map.put(SlopeSlabShape.TOP_TOP_HALF, shapeTop);
        });
    }

    public record ShapeKey(boolean top, boolean topHalf) {
    }
}

