/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.client.GatewayParticle;
import dev.shadowsoffire.gateways.client.GatewayRenderer;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(value={Dist.CLIENT}, modid="gateways")
public class GatewaysClient {
    public static final ResourceLocation WHITE_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress");
    public static final ResourceLocation WHITE_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background");
    @Nullable
    public static Rect2i bossBarRect = null;

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ItemProperties.register((Item)((Item)GatewayObjects.GATE_PEARL.value()), (ResourceLocation)Gateways.loc("size"), (stack, level, entity, seed) -> {
            DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
            if (gate.isBound()) {
                return ((Gateway)gate.get()).size().ordinal();
            }
            return 2.0f;
        }));
        NeoForge.EVENT_BUS.addListener(GatewaysClient::bossRenderPre);
        NeoForge.EVENT_BUS.addListener(GatewaysClient::renderPre);
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
            if (gate.isBound()) {
                return 0xFF000000 | ((Gateway)gate.get()).color().getValue();
            }
            return -5592321;
        }, new ItemLike[]{(ItemLike)GatewayObjects.GATE_PEARL.value()});
    }

    @SubscribeEvent
    public static void eRenders(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer(GatewayObjects.NORMAL_GATEWAY.get(), GatewayRenderer::new);
        e.registerEntityRenderer(GatewayObjects.ENDLESS_GATEWAY.get(), GatewayRenderer::new);
    }

    @SubscribeEvent
    public static void factories(RegisterParticleProvidersEvent e) {
        e.registerSprite(GatewayObjects.GLOW.get(), GatewayParticle::new);
    }

    public static void renderPre(RenderFrameEvent.Pre event) {
        bossBarRect = null;
    }

    public static void bossRenderPre(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent boss = event.getBossEvent();
        String name = boss.getName().getString();
        if (name.startsWith("GATEWAY_ID")) {
            GatewayEntity gate;
            ClientLevel level = Minecraft.getInstance().level;
            event.setCanceled(true);
            Entity entity = level.getEntity(Integer.valueOf(name.substring(10)).intValue());
            if (entity instanceof GatewayEntity && (gate = (GatewayEntity)entity).isValid()) {
                gate.getGateway().renderBossBar(gate, event.getGuiGraphics(), event.getX(), event.getY(), false);
                event.setIncrement(event.getIncrement() * 2);
            }
        }
        bossBarRect = new Rect2i(event.getX(), 0, 200, event.getY() + event.getIncrement());
    }

    public static void drawReversedDropShadow(GuiGraphics gfx, Font font, Component comp, int x, int y) {
        gfx.drawString(font, comp, x, y, 0, false);
        PoseStack pose = gfx.pose();
        pose.pushPose();
        pose.translate(1.0, 1.0, 0.03);
        int color = comp.getStyle().getColor().getValue();
        int r = (color >> 16 & 0xFF) / 4;
        int g = (color >> 8 & 0xFF) / 4;
        int b = (color & 0xFF) / 4;
        color = 0xFF000000 | r << 16 | g << 8 | b;
        gfx.drawString(font, comp.getString(), x, y, color, false);
        pose.popPose();
    }
}

