/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class DataModelRegistry
extends DynamicRegistry<DataModel> {
    public static final DataModelRegistry INSTANCE = new DataModelRegistry();
    private Multimap<EntityType<?>, DataModel> modelsByType = HashMultimap.create();

    public DataModelRegistry() {
        super(HostileNetworks.LOGGER, "data_models", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(HostileNetworks.loc("data_model"), DataModel.CODEC);
    }

    protected void beginReload(DynamicRegistry.ReloadType type) {
        super.beginReload(type);
        this.modelsByType = HashMultimap.create();
    }

    protected void onReload(DynamicRegistry.ReloadType type) {
        super.onReload(type);
        this.modelsByType = ImmutableMultimap.copyOf(this.modelsByType);
    }

    protected void validateItem(ResourceLocation key, DataModel model) {
        model.entityAndVariants().forEach(type -> {
            Collection existingModels = this.modelsByType.get(type);
            if (existingModels.isEmpty()) {
                this.modelsByType.put(type, (Object)model);
            } else if (existingModels.size() == 1) {
                DataModel existing = (DataModel)existingModels.iterator().next();
                if (!existing.hasAttunement() || !model.hasAttunement()) {
                    this.throwAttunementError(key, (EntityType<?>)type, existingModels);
                }
                this.modelsByType.put(type, (Object)model);
            } else {
                if (!model.hasAttunement()) {
                    this.throwAttunementError(key, (EntityType<?>)type, existingModels);
                }
                this.modelsByType.put(type, (Object)model);
            }
        });
    }

    @Nullable
    public Collection<DataModel> getForEntity(EntityType<?> type) {
        return this.modelsByType.get(type);
    }

    public Map<ResourceLocation, JsonElement> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return super.prepare(pResourceManager, pProfiler);
    }

    private void throwAttunementError(ResourceLocation key, EntityType<?> type, Collection<DataModel> existingModels) {
        Object msg = "Attempted to register multiple models for Entity Type %s without specifying an attunement. When registering multiple models, ALL models must specify an attunement!";
        msg = (String)msg + " Existing models: " + String.valueOf(existingModels.stream().map(arg_0 -> ((DataModelRegistry)this).getKey(arg_0)).toList());
        msg = (String)msg + " New model: " + String.valueOf(key);
        throw new UnsupportedOperationException(String.format((String)msg, EntityType.getKey(type)));
    }
}

