/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.events.client;

import com.anthonyhilyard.iceberg.events.Event;
import com.anthonyhilyard.iceberg.events.EventFactory;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public final class RenderTooltipEvents {
    public static final Event<Gather> GATHER = EventFactory.create(Gather.class, callbacks -> (itemStack, screenWidth, screenHeight, tooltipElements, maxWidth, index) -> {
        GatherResult result = new GatherResult(InteractionResult.PASS, maxWidth, tooltipElements);
        for (Gather callback : callbacks) {
            result = callback.onGather(itemStack, screenWidth, screenHeight, result.tooltipElements, result.maxWidth, index);
            if (result.result == InteractionResult.PASS) continue;
            return result;
        }
        return result;
    });
    public static final Event<PreExt> PREEXT = EventFactory.create(PreExt.class, callbacks -> (stack, graphics, x, y, screenWidth, screenHeight, font, components, positioner, comparison, index) -> {
        PreExtResult result = new PreExtResult(InteractionResult.PASS, x, y, screenWidth, screenHeight, font);
        for (PreExt callback : callbacks) {
            result = callback.onPre(stack, graphics, result.x, result.y, result.screenWidth, result.screenHeight, result.font, components, positioner, comparison, index);
            if (result.result == InteractionResult.PASS) continue;
            return result;
        }
        return result;
    });
    public static final Event<ColorExt> COLOREXT = EventFactory.create(ColorExt.class, callbacks -> (stack, graphics, x, y, font, backgroundStart, backgroundEnd, borderStart, borderEnd, components, comparison, index) -> {
        ColorExtResult result = new ColorExtResult(backgroundStart, backgroundEnd, borderStart, borderEnd);
        for (ColorExt callback : callbacks) {
            result = callback.onColor(stack, graphics, x, y, font, result.backgroundStart, result.backgroundEnd, result.borderStart, result.borderEnd, components, comparison, index);
        }
        return result;
    });
    public static final Event<PostExt> POSTEXT = EventFactory.create(PostExt.class, callbacks -> (stack, graphics, x, y, font, width, height, components, comparison, index) -> {
        for (PostExt callback : callbacks) {
            callback.onPost(stack, graphics, x, y, font, width, height, components, comparison, index);
        }
    });

    @FunctionalInterface
    public static interface PostExt {
        public void onPost(ItemStack var1, GuiGraphics var2, int var3, int var4, Font var5, int var6, int var7, List<ClientTooltipComponent> var8, boolean var9, int var10);
    }

    @FunctionalInterface
    public static interface ColorExt {
        public ColorExtResult onColor(ItemStack var1, GuiGraphics var2, int var3, int var4, Font var5, int var6, int var7, int var8, int var9, List<ClientTooltipComponent> var10, boolean var11, int var12);
    }

    public record ColorExtResult(int backgroundStart, int backgroundEnd, int borderStart, int borderEnd) {
    }

    @FunctionalInterface
    public static interface PreExt {
        public PreExtResult onPre(ItemStack var1, GuiGraphics var2, int var3, int var4, int var5, int var6, Font var7, List<ClientTooltipComponent> var8, ClientTooltipPositioner var9, boolean var10, int var11);
    }

    public record PreExtResult(InteractionResult result, int x, int y, int screenWidth, int screenHeight, Font font) {
    }

    @FunctionalInterface
    public static interface Gather {
        public GatherResult onGather(ItemStack var1, int var2, int var3, List<Either<FormattedText, TooltipComponent>> var4, int var5, int var6);
    }

    public record GatherResult(InteractionResult result, int maxWidth, List<Either<FormattedText, TooltipComponent>> tooltipElements) {
    }
}

