/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public abstract class MultiblockRecipe
extends IESerializableRecipe
implements IMultiblockRecipe,
IJEIRecipe {
    private final int baseEnergy;
    private final int baseTime;
    private final RecipeMultiplier multipliers;
    private List<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(0);
    protected TagOutputList outputList = TagOutputList.EMPTY;
    protected List<SizedFluidIngredient> fluidInputList;
    protected List<FluidStack> fluidOutputList;

    protected <T extends Recipe<?>> MultiblockRecipe(TagOutput outputDummy, IERecipeTypes.TypeWithClass<T> type, int baseTime, int baseEnergy, Supplier<RecipeMultiplier> multipliers) {
        super(outputDummy, type);
        this.baseEnergy = baseEnergy;
        this.baseTime = baseTime;
        this.multipliers = multipliers.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        NonNullList<ItemStack> outputs = this.getItemOutputs();
        if (outputs != null && outputs.size() > 0) {
            return (ItemStack)outputs.get(0);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public List<IngredientWithSize> getItemInputs() {
        return this.inputList;
    }

    protected void setInputListWithSizes(List<IngredientWithSize> inputList) {
        this.inputList = new ArrayList<IngredientWithSize>(inputList);
    }

    protected void setInputList(List<Ingredient> inputList) {
        this.inputList = inputList.stream().map(IngredientWithSize::new).collect(Collectors.toList());
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return this.outputList.get();
    }

    @Override
    public List<SizedFluidIngredient> getFluidInputs() {
        return this.fluidInputList;
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputList;
    }

    @Override
    public int getTotalProcessTime() {
        return (int)Math.max(1.0, (double)this.baseTime * this.multipliers.timeModifier.getAsDouble());
    }

    @Override
    public int getTotalProcessEnergy() {
        return (int)Math.max(1.0, (double)this.baseEnergy * this.multipliers.energyModifier.getAsDouble());
    }

    public int getBaseEnergy() {
        return this.baseEnergy;
    }

    public int getBaseTime() {
        return this.baseTime;
    }

    public record RecipeMultiplier(DoubleSupplier timeModifier, DoubleSupplier energyModifier) {
    }
}

