/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;

public class MultitankArea
extends InfoArea {
    private final int capacity;
    private final Supplier<List<FluidStack>> getFluids;

    public MultitankArea(Rect2i area, int capacity, Supplier<List<FluidStack>> getFluids) {
        super(area);
        this.capacity = capacity;
        this.getFluids = getFluids;
    }

    @Override
    protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        if (this.getFluids().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersiveengineering.empty"));
        } else {
            int myRelative = this.area.getY() + this.area.getHeight() - mouseY;
            this.forEachFluid((fluid, lastY, newY) -> {
                if (myRelative >= lastY && myRelative < newY) {
                    FluidInfoArea.fillTooltip(fluid, this.capacity, tooltip::add);
                }
            });
        }
    }

    @Override
    public void draw(GuiGraphics graphics) {
        MultiBufferSource.BufferSource buffers = graphics.bufferSource();
        this.forEachFluid((fluid, lastY, newY) -> GuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffers, graphics.pose(), fluid, this.area.getX(), this.area.getY() + this.area.getHeight() - newY, this.area.getWidth(), newY - lastY));
    }

    private void forEachFluid(TankVisitor visitor) {
        int fluidUpToNow = 0;
        int lastY = 0;
        List<FluidStack> fluids = this.getFluids();
        for (int i = fluids.size() - 1; i >= 0; --i) {
            FluidStack fs = fluids.get(i);
            if (fs.isEmpty()) continue;
            int newY = (int)((float)this.area.getHeight() * ((float)(fluidUpToNow += fs.getAmount()) / (float)this.capacity));
            visitor.visit(fs, lastY, newY);
            lastY = newY;
        }
    }

    private List<FluidStack> getFluids() {
        return this.getFluids.get();
    }

    private static interface TankVisitor {
        public void visit(FluidStack var1, int var2, int var3);
    }
}

