/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class BlockItemIE
extends BlockItem {
    private int burnTime;

    public BlockItemIE(Block b, Item.Properties props) {
        super(b, props);
    }

    public BlockItemIE(Block b) {
        this(b, new Item.Properties());
    }

    public String getDescriptionId() {
        return this.getBlock().getDescriptionId();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag advanced) {
        IIEBlock ieBlock;
        Block block = this.getBlock();
        if (block instanceof IIEBlock && (ieBlock = (IIEBlock)block).hasFlavour()) {
            String flavourKey = "desc.immersiveengineering.flavour." + ieBlock.getNameForFlavour();
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)flavourKey), ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, ctx, tooltip, advanced);
        if (stack.has(IEDataComponents.GENERIC_ENERGY)) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stack.get(IEDataComponents.GENERIC_ENERGY)}), ChatFormatting.GRAY));
        }
        if (stack.has(IEDataComponents.GENERIC_FLUID)) {
            FluidStack fs = ((SimpleFluidContent)stack.get(IEDataComponents.GENERIC_FLUID)).copy();
            tooltip.add((Component)Component.translatable((String)"desc.immersiveengineering.info.fluidStored", (Object[])new Object[]{fs.getHoverName(), fs.getAmount()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public BlockItemIE setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        Block b = newState.getBlock();
        if (b instanceof IEBaseBlock) {
            IEBaseBlock ieBlock = (IEBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.placeBlock(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.placeBlock(context, newState);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!state.hasProperty((Property)IEProperties.MULTIBLOCKSLAVE)) {
            return super.updateCustomBlockEntityTag(pos, worldIn, player, stack, state);
        }
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        ItemContainerContents items = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (items != null) {
            return Optional.of(new BundleTooltip(new BundleContents(items.stream().toList())));
        }
        return super.getTooltipImage(stack);
    }

    public boolean canFitInsideContainerItems() {
        IEBaseBlock ieBlock;
        Block block = this.getBlock();
        return !(block instanceof IEBaseBlock) || (ieBlock = (IEBaseBlock)block).fitsIntoContainer();
    }
}

