/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.sound.NoisyToolSoundHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageNoisyToolHarvestUpdate(int noisyToolHolderID, byte actionOrdinal, BlockPos targetPos) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageNoisyToolHarvestUpdate> ID = IMessage.createType("noisy_tool_harvesting_update");
    public static final StreamCodec<ByteBuf, MessageNoisyToolHarvestUpdate> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageNoisyToolHarvestUpdate::noisyToolHolderID, (StreamCodec)ByteBufCodecs.BYTE, MessageNoisyToolHarvestUpdate::actionOrdinal, (StreamCodec)BlockPos.STREAM_CODEC, MessageNoisyToolHarvestUpdate::targetPos, MessageNoisyToolHarvestUpdate::new);

    public MessageNoisyToolHarvestUpdate(LivingEntity noisyToolHolder, PlayerInteractEvent.LeftClickBlock.Action action, BlockPos targetPos) {
        this(noisyToolHolder.getId(), (byte)action.ordinal(), targetPos);
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (entity = world.getEntity(this.noisyToolHolderID)) instanceof LivingEntity) {
                LivingEntity noisyToolHolder = (LivingEntity)entity;
                NoisyToolSoundHandler.handleHarvestAction(noisyToolHolder, ((PlayerInteractEvent.LeftClickBlock.Action[])PlayerInteractEvent.LeftClickBlock.Action.class.getEnumConstants())[this.actionOrdinal], this.targetPos);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

