/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.EvaluationException;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.config.ExpressionConfiguration;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.DataAccessorIfc;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.AbstractFunction;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.FunctionParameter;
import snownee.kiwi.shadowed.com.ezylang.evalex.operators.AbstractOperator;
import snownee.kiwi.shadowed.com.ezylang.evalex.operators.InfixOperator;
import snownee.kiwi.shadowed.com.ezylang.evalex.parser.ASTNode;
import snownee.kiwi.shadowed.com.ezylang.evalex.parser.Token;

public class KEval {
    private static final ExpressionConfiguration CONFIG = ExpressionConfiguration.builder().defaultConstants(KEval.generateConstants()).dataAccessorSupplier(() -> DataAccessor.INSTANCE).singleQuoteStringLiteralsAllowed(true).build();

    private static Map<String, EvaluationValue> generateConstants() {
        TreeMap<String, EvaluationValue> map = new TreeMap<String, EvaluationValue>(ExpressionConfiguration.StandardConstants);
        map.put("MC", EvaluationValue.arrayValue(IntList.of((int[])Platform.getVersionNumber("minecraft"))));
        map.put("DEVENV", EvaluationValue.booleanValue(!Platform.isProduction()));
        map.put("ISCLIENT", EvaluationValue.booleanValue(Platform.isPhysicalClient()));
        map.put("MODLOADER", EvaluationValue.stringValue(Platform.getPlatform().name()));
        return map;
    }

    public static ExpressionConfiguration config() {
        return CONFIG;
    }

    static {
        KEval.config().getFunctionDictionary().addFunction("HAS", new HasFunction());
        KEval.config().getFunctionDictionary().addFunction("VER", new VerFunction());
        KEval.config().getFunctionDictionary().addFunction("RESET", new ResetFunction());
        KEval.config().getOperatorDictionary().addOperator("=", new AssignmentOperator());
        KEval.config().getOperatorDictionary().addOperator("??", new NullishCoalescingOperator());
    }

    private static class DataAccessor
    implements DataAccessorIfc {
        static final DataAccessor INSTANCE = new DataAccessor();
        private final Map<String, EvaluationValue> variables = new TreeMap<String, EvaluationValue>();

        private DataAccessor() {
        }

        @Override
        public EvaluationValue getData(String variable) {
            if (KiwiCommonConfig.vars.containsKey(variable)) {
                return EvaluationValue.of(KiwiCommonConfig.vars.get(variable), KEval.config());
            }
            return this.variables.get(variable);
        }

        @Override
        public void setData(String variable, EvaluationValue value) {
            if (KiwiCommonConfig.vars.containsKey(variable)) {
                throw new IllegalArgumentException("Cannot assign to constant");
            }
            this.variables.put(variable, value);
        }
    }

    @FunctionParameter(name="id")
    private static class HasFunction
    extends AbstractFunction {
        private HasFunction() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
            String string = parameterValues[0].getStringValue();
            if (string.startsWith("@")) {
                return EvaluationValue.booleanValue(KiwiModules.isLoaded(ResourceLocation.parse((String)string.substring(1))));
            }
            return EvaluationValue.booleanValue(Platform.isModLoaded(string));
        }
    }

    @FunctionParameter(name="id")
    private static class VerFunction
    extends AbstractFunction {
        private final Map<String, IntList> cache = Maps.newHashMap();

        private VerFunction() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
            String s = parameterValues[0].getStringValue();
            if (!Platform.isModLoaded(s)) {
                return EvaluationValue.NULL_VALUE;
            }
            return EvaluationValue.arrayValue((List)this.cache.computeIfAbsent(s, id -> IntList.of((int[])Platform.getVersionNumber(id))));
        }
    }

    private static class ResetFunction
    extends AbstractFunction {
        private ResetFunction() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
            ((DataAccessor)expression.getDataAccessor()).variables.clear();
            return EvaluationValue.stringValue("Variables reset");
        }
    }

    @InfixOperator(precedence=-1, operandsLazy=true)
    private static class AssignmentOperator
    extends AbstractOperator {
        private AssignmentOperator() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
            List<ASTNode> parameters;
            try {
                parameters = expression.getAbstractSyntaxTree().getParameters();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (Object)"Assignment operator must have exactly two operands");
            ASTNode left = parameters.getFirst();
            Preconditions.checkArgument((left.getToken().getType() == Token.TokenType.VARIABLE_OR_CONSTANT ? 1 : 0) != 0, (Object)"Left side of assignment must be a variable");
            String varName = left.getToken().getValue();
            if (expression.getConstants().containsKey(varName)) {
                throw new IllegalArgumentException("Cannot assign to constant");
            }
            EvaluationValue value = expression.evaluateSubtree(operands[1].getExpressionNode());
            expression.getDataAccessor().setData(varName, value);
            return value;
        }
    }

    @InfixOperator(precedence=2, operandsLazy=true)
    private static class NullishCoalescingOperator
    extends AbstractOperator {
        private NullishCoalescingOperator() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) {
            if (operands[0].isNullValue()) {
                return operands[1];
            }
            return operands[0];
        }
    }
}

