/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class KiwiEntityTypeBuilder<T extends Entity> {
    private final Class<?> type;
    private EntityType.EntityFactory<T> factory;
    private MobCategory category = MobCategory.MISC;
    private ImmutableSet<Block> immuneTo = ImmutableSet.of();
    private boolean serialize = true;
    private boolean summon = true;
    private boolean fireImmune;
    private boolean canSpawnFarFromPlayer;
    private int clientTrackingRange = 5;
    private int updateInterval = 3;
    private EntityDimensions dimensions = EntityDimensions.scalable((float)0.6f, (float)1.8f);
    private float spawnDimensionsScale = 1.0f;
    private EntityAttachments.Builder attachments = EntityAttachments.builder();
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
    private Boolean forceTrackedVelocityUpdates;
    @Nullable
    private Supplier<AttributeSupplier.Builder> defaultAttributeBuilder;
    private SpawnPlacementType restrictionLocation;
    private Heightmap.Types restrictionHeightmap;
    private SpawnPlacements.SpawnPredicate<T> spawnPredicate;

    private KiwiEntityTypeBuilder(Class<?> type) {
        this.type = type;
    }

    public static <T extends Entity> KiwiEntityTypeBuilder<T> create() {
        return new KiwiEntityTypeBuilder<T>(Entity.class);
    }

    public static <T extends LivingEntity> KiwiEntityTypeBuilder<T> createLiving() {
        return new KiwiEntityTypeBuilder<T>(LivingEntity.class);
    }

    public static <T extends Entity> KiwiEntityTypeBuilder<T> createMob() {
        return new KiwiEntityTypeBuilder<T>(Mob.class);
    }

    public KiwiEntityTypeBuilder<T> spawnGroup(MobCategory group) {
        Objects.requireNonNull(group, "Spawn group cannot be null");
        this.category = group;
        return this;
    }

    public <N extends T> KiwiEntityTypeBuilder<N> entityFactory(EntityType.EntityFactory<N> factory) {
        Objects.requireNonNull(factory, "Entity Factory cannot be null");
        this.factory = factory;
        return this;
    }

    public KiwiEntityTypeBuilder<T> dimensions(EntityDimensions dimensions) {
        Objects.requireNonNull(dimensions, "Cannot set null dimensions");
        this.dimensions = dimensions;
        return this;
    }

    public KiwiEntityTypeBuilder<T> spawnDimensionsScale(float p_338311_) {
        this.spawnDimensionsScale = p_338311_;
        return this;
    }

    public KiwiEntityTypeBuilder<T> eyeHeight(float p_316663_) {
        this.dimensions = this.dimensions.withEyeHeight(p_316663_);
        return this;
    }

    public KiwiEntityTypeBuilder<T> passengerAttachments(float ... p_316352_) {
        for (float f : p_316352_) {
            this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, 0.0f, f, 0.0f);
        }
        return this;
    }

    public KiwiEntityTypeBuilder<T> passengerAttachments(Vec3 ... p_316160_) {
        for (Vec3 vec3 : p_316160_) {
            this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, vec3);
        }
        return this;
    }

    public KiwiEntityTypeBuilder<T> vehicleAttachment(Vec3 p_316758_) {
        return this.attach(EntityAttachment.VEHICLE, p_316758_);
    }

    public KiwiEntityTypeBuilder<T> ridingOffset(float p_316455_) {
        return this.attach(EntityAttachment.VEHICLE, 0.0f, -p_316455_, 0.0f);
    }

    public KiwiEntityTypeBuilder<T> nameTagOffset(float p_316662_) {
        return this.attach(EntityAttachment.NAME_TAG, 0.0f, p_316662_, 0.0f);
    }

    public KiwiEntityTypeBuilder<T> attach(EntityAttachment p_320654_, float p_320819_, float p_320871_, float p_320278_) {
        this.attachments = this.attachments.attach(p_320654_, p_320819_, p_320871_, p_320278_);
        return this;
    }

    public KiwiEntityTypeBuilder<T> attach(EntityAttachment p_320601_, Vec3 p_320745_) {
        this.attachments = this.attachments.attach(p_320601_, p_320745_);
        return this;
    }

    public KiwiEntityTypeBuilder<T> disableSummon() {
        this.summon = false;
        return this;
    }

    public KiwiEntityTypeBuilder<T> disableSaving() {
        this.serialize = false;
        return this;
    }

    public KiwiEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public KiwiEntityTypeBuilder<T> specificSpawnBlocks(Block ... blocks) {
        this.immuneTo = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public KiwiEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.canSpawnFarFromPlayer = true;
        return this;
    }

    public KiwiEntityTypeBuilder<T> trackRangeChunks(int i) {
        this.clientTrackingRange = i;
        return this;
    }

    public KiwiEntityTypeBuilder<T> trackedUpdateRate(int i) {
        this.updateInterval = i;
        return this;
    }

    public KiwiEntityTypeBuilder<T> requiredFeatures(FeatureFlag ... featureFlags) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(featureFlags);
        return this;
    }

    public KiwiEntityTypeBuilder<T> forceTrackedVelocityUpdates(boolean forceTrackedVelocityUpdates) {
        this.forceTrackedVelocityUpdates = forceTrackedVelocityUpdates;
        return this;
    }

    public KiwiEntityTypeBuilder<T> defaultAttributes(Supplier<AttributeSupplier.Builder> defaultAttributeBuilder) {
        Objects.requireNonNull(defaultAttributeBuilder, "Cannot set null attribute builder");
        Preconditions.checkState((this.type == LivingEntity.class || this.type == Mob.class ? 1 : 0) != 0, (Object)"Only living entities can have default attributes.");
        this.defaultAttributeBuilder = defaultAttributeBuilder;
        return this;
    }

    public KiwiEntityTypeBuilder<T> spawnRestriction(SpawnPlacementType location, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        Preconditions.checkState((this.type == Mob.class ? 1 : 0) != 0, (Object)"Only mobs can have spawn restrictions.");
        this.restrictionLocation = Objects.requireNonNull(location, "Location cannot be null.");
        this.restrictionHeightmap = Objects.requireNonNull(heightmap, "Heightmap type cannot be null.");
        this.spawnPredicate = Objects.requireNonNull(spawnPredicate, "Spawn predicate cannot be null.");
        return this;
    }

    public EntityType<T> build() {
        return new EntityType(this.factory, this.category, this.serialize, this.summon, this.fireImmune, this.canSpawnFarFromPlayer, this.immuneTo, this.dimensions.withAttachments(this.attachments), this.spawnDimensionsScale, this.clientTrackingRange, this.updateInterval, this.requiredFeatures);
    }
}

