/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class CustomAction
implements PostAction {
    private final PostActionCommonProperties commonProperties;
    public final String id;
    public final JsonObject data;
    public boolean repeatable;
    public boolean preventSync;
    @Nullable
    public Apply applyFunc;

    public CustomAction(PostActionCommonProperties commonProperties, String id, JsonObject json, boolean repeatable, boolean preventSync) {
        this.commonProperties = commonProperties;
        this.id = id;
        this.data = json;
        this.repeatable = repeatable;
    }

    public PostActionType<CustomAction> type() {
        return PostActionTypes.CUSTOM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        if (this.applyFunc != null) {
            this.applyFunc.apply(recipe, context, times);
        }
    }

    @Override
    public boolean preventSync() {
        return this.preventSync;
    }

    @Override
    public boolean repeatable() {
        return this.repeatable;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        CommonProxy.postCustomActionEvent(this.id, this, recipe);
    }

    @Override
    public PostActionCommonProperties commonProperties() {
        return this.commonProperties;
    }

    public String id() {
        return this.id;
    }

    public JsonObject data() {
        return this.data;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"recipeType.lychee.custom.%s".formatted(this.id));
    }

    @FunctionalInterface
    public static interface Apply {
        public void apply(@Nullable ILycheeRecipe<?> var1, LycheeContext var2, int var3);
    }

    public static class Type
    implements PostActionType<CustomAction> {
        public static final MapCodec<CustomAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(CustomAction::commonProperties), (App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("id").forGetter(CustomAction::id), (App)ExtraCodecs.JSON.comapFlatMap(it -> LycheeCodecs.tryCatch(() -> ((JsonElement)it).getAsJsonObject()), Function.identity()).optionalFieldOf("data", (Object)new JsonObject()).forGetter(CustomAction::data), (App)Codec.BOOL.optionalFieldOf("repeatable", (Object)true).forGetter(CustomAction::repeatable), (App)Codec.BOOL.optionalFieldOf("preventSync", (Object)false).forGetter(CustomAction::preventSync)).apply((Applicative)instance, CustomAction::new));

        @Override
        public MapCodec<CustomAction> codec() {
            return CODEC;
        }
    }
}

