/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;
import snownee.kiwi.util.Color;
import snownee.lychee.client.gui.FluidRenderer;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.UIRenderHelper;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.VecHelper;

public class GuiGameElement {
    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(ItemLike itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState blockState) {
        if (blockState.getRenderShape() != RenderShape.MODEL && blockState.getFluidState().isEmpty()) {
            return new GuiBlockStateRenderBuilder(blockState, GuiGameElement.of((ItemLike)blockState.getBlock()));
        }
        if (blockState.getBlock() instanceof StairBlock) {
            blockState = (BlockState)blockState.setValue((Property)StairBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)StairBlock.FACING)).getOpposite());
        }
        return new GuiBlockStateRenderBuilder(blockState);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.defaultFluidState().createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
            this.scale = 10.0;
        }

        public GuiItemRenderBuilder(ItemLike provider) {
            this(provider.asItem().getDefaultInstance());
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack matrixStack = graphics.pose();
            this.prepareMatrix(matrixStack);
            this.transformMatrix(matrixStack);
            GuiItemRenderBuilder.renderItemIntoGUI(matrixStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(matrixStack);
        }

        @Override
        protected void transformMatrix(PoseStack matrixStack) {
            matrixStack.translate(this.x(), this.y(), this.z());
            matrixStack.translate(this.xLocal * this.scale, this.yLocal * this.scale, this.zLocal * this.scale);
            UIRenderHelper.flipForGuiRender(matrixStack);
        }

        public static void renderItemIntoGUI(PoseStack matrixStack, ItemStack stack, boolean useDefaultLighting) {
            boolean flatLighting;
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            BakedModel bakedModel = renderer.getModel(stack, null, null, 0);
            Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 100.0f);
            matrixStack.translate(8.0f, -8.0f, 0.0f);
            matrixStack.scale(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean bl = flatLighting = !bakedModel.usesBlockLight();
            if (useDefaultLighting && flatLighting) {
                Lighting.setupForFlatItems();
            }
            renderer.render(stack, ItemDisplayContext.GUI, false, matrixStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
            RenderSystem.disableDepthTest();
            buffer.endBatch();
            RenderSystem.enableDepthTest();
            if (useDefaultLighting && flatLighting) {
                Lighting.setupFor3DItems();
            }
            matrixStack.popPose();
        }

        @Override
        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            return this;
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        @Nullable
        private final GuiRenderBuilder override;

        public GuiBlockStateRenderBuilder(BlockState blockState) {
            this(blockState, null);
        }

        public GuiBlockStateRenderBuilder(BlockState blockState, @Nullable GuiRenderBuilder override) {
            super(Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState), blockState);
            this.override = override;
        }

        @Override
        public void render(GuiGraphics graphics) {
            if (this.override != null) {
                ((RenderElement)this.override.atLocal(this.xLocal, this.yLocal, this.zLocal).at((Vector2fc)this.position)).offset(-3.0f, -3.0f).render(graphics);
            }
            super.render(graphics);
        }

        @Override
        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            if (this.blockState.getBlock() instanceof BaseFireBlock) {
                Lighting.setupForFlatItems();
                blockRenderer.renderSingleBlock(this.blockState, ms, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
                buffer.endBatch();
                Lighting.setupFor3DItems();
                return;
            }
            super.renderModel(blockRenderer, buffer, ms);
            if (this.blockState.getFluidState().isEmpty()) {
                return;
            }
            float min = 0.001f;
            float max = 0.999f;
            FluidRenderer.renderFluidBox(this.blockState.getFluidState(), min, min, min, max, max * 0.8888889f, max, (MultiBufferSource)buffer, ms, 0xF000F0, false);
            buffer.endBatch();
        }
    }

    public static abstract class GuiRenderBuilder
    extends RenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected Vec3 rotationOffset = Vec3.ZERO;
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.ZERO));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vec3 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(PoseStack matrixStack) {
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(matrixStack);
        }

        protected void transformMatrix(PoseStack matrixStack) {
            float scale = (float)this.scale;
            matrixStack.translate(this.x(), this.y() + scale, this.z());
            matrixStack.scale(scale, scale, scale);
            matrixStack.translate(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(matrixStack);
            matrixStack.translate(this.rotationOffset.x, this.rotationOffset.y, this.rotationOffset.z);
            matrixStack.mulPose(Axis.ZP.rotationDegrees((float)this.zRot));
            matrixStack.mulPose(Axis.XP.rotationDegrees((float)this.xRot));
            matrixStack.mulPose(Axis.YP.rotationDegrees((float)this.yRot));
            matrixStack.translate(-this.rotationOffset.x, -this.rotationOffset.y, -this.rotationOffset.z);
        }

        protected void cleanUpMatrix(PoseStack matrixStack) {
            matrixStack.popPose();
            this.cleanUpLighting(matrixStack);
        }

        protected void prepareLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                Lighting.setupFor3DItems();
            }
        }

        protected void cleanUpLighting(PoseStack matrixStack) {
            if (this.customLighting != null) {
                Lighting.setupFor3DItems();
            }
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected BakedModel blockModel;
        protected BlockState blockState;
        private ModelData modelData;

        public GuiBlockModelRenderBuilder(BakedModel bakedModel, @Nullable BlockState blockState) {
            this.blockState = blockState == null ? Blocks.AIR.defaultBlockState() : blockState;
            this.blockModel = bakedModel;
            this.withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.ZERO));
            this.modelData = ModelData.EMPTY;
            if (ClientProxy.HAS_PONDER) {
                this.modelData = VirtualRenderHelper.VIRTUAL_DATA;
            }
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack matrixStack = graphics.pose();
            this.prepareMatrix(matrixStack);
            Minecraft mc = Minecraft.getInstance();
            BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
            MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
            this.transformMatrix(matrixStack);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            this.renderModel(blockRenderer, buffer, matrixStack);
            this.cleanUpMatrix(matrixStack);
        }

        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            Minecraft mc = Minecraft.getInstance();
            int color = mc.getBlockColors().getColor(this.blockState, (BlockAndTintGetter)mc.level, mc.cameraEntity != null ? mc.cameraEntity.blockPosition() : null, 0);
            Color rgb = new Color(color == -1 ? this.color : color);
            blockRenderer.getModelRenderer().renderModel(ms.last(), buffer.getBuffer(this.blockState.getBlock() == Blocks.AIR ? Sheets.translucentCullBlockSheet() : ItemBlockRenderTypes.getRenderType((BlockState)this.blockState, (boolean)true)), this.blockState, this.blockModel, rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), 0xF000F0, OverlayTexture.NO_OVERLAY, this.modelData, null);
            buffer.endBatch();
        }
    }
}

