/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.KUtil;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.util.ui.CategoryMetadata;
import snownee.lychee.util.ui.CategoryModifier;
import snownee.lychee.util.ui.InputAction;

public abstract class RvHelper {
    private List<RecipeHolder<CategoryMetadata>> metadataList = List.of();
    private List<RecipeHolder<CategoryModifier>> modifierList = List.of();

    public void init() {
        Comparator<RecipeHolder> comparator = Comparator.comparing(RecipeHolder::value);
        this.metadataList = ImmutableList.sortedCopyOf(comparator, (Iterable)KUtil.getRecipes(RecipeTypes.CATEGORY_METADATA));
        this.modifierList = ImmutableList.sortedCopyOf(comparator, (Iterable)KUtil.getRecipes(RecipeTypes.CATEGORY_MODIFIER));
    }

    public RecipeHolder<CategoryMetadata> getMetadata(RvCategoryInstance<?> category) {
        String id = category.id().toString();
        for (RecipeHolder<CategoryMetadata> metadata : this.metadataList) {
            if (!((CategoryMetadata)metadata.value()).category().test(id)) continue;
            return metadata;
        }
        return CategoryMetadata.EMPTY;
    }

    public List<RecipeHolder<CategoryModifier>> getModifiers(RvCategoryInstance<?> category) {
        String id = category.id().toString();
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<CategoryModifier> modifier : this.modifierList) {
            if (!((CategoryModifier)modifier.value()).category().test(id)) continue;
            list.add(modifier);
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public abstract boolean doAction(ItemStack var1, InputAction.Direct var2);

    public boolean doAction(Block block, InputAction.Direct action) {
        return this.doAction(block.asItem().getDefaultInstance(), action);
    }

    public boolean doAction(BlockState blockState, InputAction.Direct action) {
        if (blockState.is(Blocks.CHIPPED_ANVIL) || blockState.is(Blocks.DAMAGED_ANVIL)) {
            blockState = Blocks.ANVIL.defaultBlockState();
        }
        if (blockState.getBlock() instanceof LiquidBlock) {
            return this.doAction(blockState.getFluidState(), action);
        }
        return this.doAction(blockState.getBlock(), action);
    }

    public abstract boolean doAction(Fluid var1, InputAction.Direct var2);

    public boolean doAction(FluidState fluidState, InputAction.Direct action) {
        return this.doAction(fluidState.getType(), action);
    }

    private Optional<InputAction.Direct> toDirectAction(InputAction action, @Nullable InteractiveRenderElement element) {
        if (!action.isMouseOver(element)) {
            return Optional.empty();
        }
        return this.toDirectAction(action);
    }

    public abstract Optional<InputAction.Direct> toDirectAction(InputAction var1);

    public BiPredicate<InputAction, InteractiveRenderElement> inputOnBlock(Supplier<BlockState> blockStateSupplier) {
        return (action, element) -> this.toDirectAction((InputAction)action, (InteractiveRenderElement)element).map(arg_0 -> this.lambda$inputOnBlock$0((Supplier)blockStateSupplier, arg_0)).orElse(false);
    }

    public abstract boolean appendModName();

    private /* synthetic */ Boolean lambda$inputOnBlock$0(Supplier blockStateSupplier, InputAction.Direct direct) {
        return this.doAction((BlockState)blockStateSupplier.get(), direct);
    }
}

