/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.BlockCrushingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.BlockExplodingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.BlockInteractingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.DripstoneRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemBurningRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemExplodingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemInsideRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.LightningChannelingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstanceProviders;
import snownee.lychee.compat.recipeviewer.element.SideBlockIcon;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class RvPlugin<Helper extends RvHelper> {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Map<ResourceLocation, RvCategory<?>> categoryTypes = Maps.newHashMap();
    private ImmutableMap<ResourceLocation, RvCategoryInstance<?>> categories = ImmutableMap.of();
    private final String name = STACK_WALKER.getCallerClass().getSimpleName();
    private final Helper rvHelper;

    public RvPlugin(Helper rvHelper) {
        this.rvHelper = rvHelper;
    }

    public Helper helper() {
        return this.rvHelper;
    }

    public void init() {
        this.categoryTypes.clear();
        ((RvHelper)this.rvHelper).init();
        HashMap categories = Maps.newHashMap();
        this.register(RecipeTypes.BLANK, new RvCategory(), it -> {
            it.iconProvider = category -> RenderElement.empty();
        });
        this.register(RecipeTypes.BLOCK_CRUSHING, new BlockCrushingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> BlockCrushingRecipeCategory.icon(GuiGameElement.of((ItemLike)Items.ANVIL));
            it.setSimpleWorkstationProvider(category -> category.recipes().stream().map($ -> ((BlockCrushingRecipe)$.value()).blockPredicate()).filter($ -> !BlockPredicateExtensions.isAny($)).distinct().flatMap($ -> BlockPredicateExtensions.matchedBlocks($).stream()).distinct().map(ItemStack::new).toList());
        });
        this.register(RecipeTypes.BLOCK_EXPLODING, new BlockExplodingRecipeCategory(), it -> {
            it.iconProvider = category -> {
                GuiGameElement.GuiRenderBuilder mainIcon = GuiGameElement.of((ItemLike)Items.TNT);
                return new SideBlockIcon(mainIcon, (Supplier<BlockState>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
            };
            it.setSimpleWorkstationProvider(category -> List.of(Items.TNT.getDefaultInstance()));
        });
        this.register(RecipeTypes.BLOCK_INTERACTING, new BlockInteractingRecipeCategory(), type -> {
            type.width += 30;
            type.iconProvider = category -> {
                AllGuiTextures mainIcon = category.recipes().stream().map($ -> ((BlockInteractingRecipe)$.value()).getType()).anyMatch($ -> $ == RecipeTypes.BLOCK_INTERACTING) ? AllGuiTextures.RIGHT_CLICK : AllGuiTextures.LEFT_CLICK;
                return new SideBlockIcon(mainIcon, (Supplier<BlockState>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
            };
        });
        this.register(RecipeTypes.DRIPSTONE_DRIPPING, new DripstoneRecipeCategory(), it -> {
            it.iconProvider = category -> GuiGameElement.of((ItemLike)Items.POINTED_DRIPSTONE);
            it.setSimpleWorkstationProvider(category -> List.of(Items.POINTED_DRIPSTONE.getDefaultInstance()));
        });
        this.register(RecipeTypes.LIGHTNING_CHANNELING, new LightningChannelingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> GuiGameElement.of((ItemLike)Items.LIGHTNING_ROD);
            it.setSimpleWorkstationProvider(category -> List.of(Items.LIGHTNING_ROD.getDefaultInstance()));
        });
        this.register(RecipeTypes.ITEM_EXPLODING, new ItemExplodingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> GuiGameElement.of((ItemLike)Items.TNT);
            it.setSimpleWorkstationProvider(category -> List.of(Items.TNT.getDefaultInstance()));
        });
        this.register(RecipeTypes.ITEM_BURNING, new ItemBurningRecipeCategory(), it -> {
            it.iconProvider = category -> new SideBlockIcon(AllGuiTextures.DOWN_ARROW, (Supplier<BlockState>)Suppliers.memoize(() -> ((Block)Blocks.FIRE).defaultBlockState()));
        });
        this.register(RecipeTypes.ITEM_INSIDE, new ItemInsideRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> new SideBlockIcon(AllGuiTextures.DOWN_ARROW, (Supplier<BlockState>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
        });
        for (LycheeRecipeType<? extends ILycheeRecipe<LycheeContext>> recipeType : RecipeTypes.ALL) {
            RvCategoryInstanceProviders.RvCategoryProvider<?> provider;
            RvCategory<?> category = this.categoryTypes.get(recipeType.categoryId);
            if (category == null || (provider = RvCategoryInstanceProviders.get(recipeType.categoryId)) == null) continue;
            Function factory = provider.get(category, (RvHelper)this.rvHelper);
            for (RecipeHolder<? extends ILycheeRecipe<LycheeContext>> recipe : recipeType.inViewerRecipes()) {
                ResourceLocation id = RVs.composeCategoryIdentifier(recipeType.categoryId, ResourceLocation.parse((String)((ILycheeRecipe)recipe.value()).group()));
                categories.computeIfAbsent(id, factory).addRecipe(recipe);
            }
        }
        this.categories = ImmutableMap.copyOf((Map)categories);
    }

    public ImmutableMap<ResourceLocation, RvCategoryInstance<?>> categories() {
        return this.categories;
    }

    public <R extends ILycheeRecipe<LycheeContext>, T extends RvCategory<R>> void register(LycheeRecipeType<R> recipeType, T category, Consumer<T> configurer) {
        category.id = recipeType.categoryId;
        configurer.accept(category);
        Preconditions.checkNotNull(category.iconProvider, (String)"Icon provider is null: %s", (Object)category.id);
        category.init();
        Preconditions.checkArgument((this.categoryTypes.put(category.id, category) == null ? 1 : 0) != 0, (String)"Duplicate category type: %s", (Object)category.id);
    }

    public String toString() {
        return "RvPlugin{" + this.name + "}";
    }
}

